/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1260;
import org.apache.commons.io.IOUtils;

@Environment(value=EnvType.CLIENT)
public final class ModResourcePackUtil {
    public static final int PACK_FORMAT_VERSION = 1;

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<class_1260> packList) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            if (container.getMetadata().getType().equals("builtin")) continue;
            Path path = container.getRootPath();
            ModNioResourcePack pack = new ModNioResourcePack(container.getMetadata(), path, null);
            if (pack.method_4372().isEmpty()) continue;
            packList.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, String filename) {
        if ("pack.mcmeta".equals(filename)) {
            String description = info.getName();
            description = description == null ? "" : description.replaceAll("\"", "\\\"");
            String pack = String.format("{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}", description);
            return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
        }
        return null;
    }

    public static String getName(ModMetadata info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return "Fabric Mod \"" + info.getId() + "\"";
    }
}

