/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.EntrypointException;
import net.fabricmc.loader.api.LanguageAdapterException;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.entrypoint.EntrypointContainerImpl;
import net.fabricmc.loader.language.LanguageAdapter;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.metadata.EntrypointMetadata;

class EntrypointStorage {
    private final Map<String, List<Entry>> entryMap = new HashMap<String, List<Entry>>();

    EntrypointStorage() {
    }

    private List<Entry> getOrCreateEntries(String key) {
        return this.entryMap.computeIfAbsent(key, z -> new ArrayList());
    }

    protected void addDeprecated(ModContainer modContainer, String adapter, String value) throws ClassNotFoundException, LanguageAdapterException {
        FabricLoader.INSTANCE.getLogger().debug("Registering 0.3.x old-style initializer " + value + " for mod " + modContainer.getInfo().getId());
        OldEntry oe = new OldEntry(modContainer, adapter, value);
        this.getOrCreateEntries("main").add(oe);
        this.getOrCreateEntries("client").add(oe);
        this.getOrCreateEntries("server").add(oe);
    }

    protected void add(ModContainer modContainer, String key, EntrypointMetadata metadata, Map<String, net.fabricmc.loader.api.LanguageAdapter> adapterMap) throws Exception {
        if (!adapterMap.containsKey(metadata.getAdapter())) {
            throw new Exception("Could not find adapter '" + metadata.getAdapter() + "' (mod " + modContainer.getInfo().getId() + "!)");
        }
        FabricLoader.INSTANCE.getLogger().debug("Registering new-style initializer " + metadata.getValue() + " for mod " + modContainer.getInfo().getId() + " (key " + key + ")");
        this.getOrCreateEntries(key).add(new NewEntry(modContainer, adapterMap.get(metadata.getAdapter()), metadata.getValue()));
    }

    boolean hasEntrypoints(String key) {
        return this.entryMap.containsKey(key);
    }

    protected <T> List<T> getEntrypoints(String key, Class<T> type) {
        List<Entry> entries = this.entryMap.get(key);
        if (entries == null) {
            return Collections.emptyList();
        }
        Throwable exception = null;
        ArrayList<T> results = new ArrayList<T>(entries.size());
        for (Entry entry : entries) {
            try {
                T result = entry.getOrCreate(type);
                if (result == null) continue;
                results.add(result);
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = new EntrypointException(key, entry.getModContainer().getMetadata().getId(), t);
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return results;
    }

    protected <T> List<EntrypointContainer<T>> getEntrypointContainers(String key, Class<T> type) {
        List<Entry> entries = this.entryMap.get(key);
        if (entries == null) {
            return Collections.emptyList();
        }
        Throwable exception = null;
        ArrayList<EntrypointContainer<T>> results = new ArrayList<EntrypointContainer<T>>(entries.size());
        for (Entry entry : entries) {
            try {
                T result = entry.getOrCreate(type);
                if (result == null) continue;
                results.add(new EntrypointContainerImpl<T>(entry.getModContainer(), result));
            }
            catch (Throwable t) {
                if (exception == null) {
                    exception = new EntrypointException(key, entry.getModContainer().getMetadata().getId(), t);
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return results;
    }

    private static class NewEntry
    implements Entry {
        private final ModContainer mod;
        private final net.fabricmc.loader.api.LanguageAdapter adapter;
        private final String value;
        private final Map<Class<?>, Object> instanceMap = new IdentityHashMap();

        private NewEntry(ModContainer mod, net.fabricmc.loader.api.LanguageAdapter adapter, String value) {
            this.mod = mod;
            this.adapter = adapter;
            this.value = value;
        }

        public String toString() {
            return this.mod.getInfo().getId() + "->(0.3.x)" + this.value;
        }

        @Override
        public <T> T getOrCreate(Class<T> type) throws Exception {
            Object o = this.instanceMap.get(type);
            if (o == null) {
                o = this.create(type);
                this.instanceMap.put(type, o);
            }
            return (T)o;
        }

        @Override
        public ModContainer getModContainer() {
            return this.mod;
        }

        private <T> T create(Class<T> type) throws Exception {
            return this.adapter.create(this.mod, this.value, type);
        }
    }

    private static class OldEntry
    implements Entry {
        private static final LanguageAdapter.Options options = LanguageAdapter.Options.Builder.create().missingSuperclassBehaviour(LanguageAdapter.MissingSuperclassBehavior.RETURN_NULL).build();
        private final ModContainer mod;
        private final String languageAdapter;
        private final String value;
        private Object object;

        private OldEntry(ModContainer mod, String languageAdapter, String value) {
            this.mod = mod;
            this.languageAdapter = languageAdapter;
            this.value = value;
        }

        public String toString() {
            return this.mod.getInfo().getId() + "->" + this.value;
        }

        @Override
        public <T> T getOrCreate(Class<T> type) throws Exception {
            if (this.object == null) {
                LanguageAdapter adapter = (LanguageAdapter)Class.forName(this.languageAdapter, true, FabricLauncherBase.getLauncher().getTargetClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]);
                this.object = adapter.createInstance(this.value, options);
            }
            if (this.object == null || !type.isAssignableFrom(this.object.getClass())) {
                return null;
            }
            return (T)this.object;
        }

        @Override
        public ModContainer getModContainer() {
            return this.mod;
        }
    }

    static interface Entry {
        public <T> T getOrCreate(Class<T> var1) throws Exception;

        public ModContainer getModContainer();
    }
}

