/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.game;

import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.entrypoint.EntrypointTransformer;
import net.fabricmc.loader.entrypoint.minecraft.EntrypointPatchBranding;
import net.fabricmc.loader.entrypoint.minecraft.EntrypointPatchBranding_1_8_9;
import net.fabricmc.loader.entrypoint.minecraft.EntrypointPatchFML125;
import net.fabricmc.loader.entrypoint.minecraft.EntrypointPatchHook;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.game.GameProviderHelper;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.metadata.BuiltinModMetadata;
import net.fabricmc.loader.minecraft.McVersionLookup;
import net.fabricmc.loader.util.Arguments;

public class MinecraftGameProvider
implements GameProvider {
    private static final Gson GSON = new Gson();
    private EnvType envType;
    private String entrypoint;
    private Arguments arguments;
    private Path gameJar;
    private Path realmsJar;
    private McVersionLookup.McVersion versionData;
    private boolean hasModLoader = false;
    public static final EntrypointTransformer TRANSFORMER = new EntrypointTransformer(it -> Arrays.asList(new EntrypointPatchHook((EntrypointTransformer)it), new EntrypointPatchBranding((EntrypointTransformer)it), new EntrypointPatchFML125((EntrypointTransformer)it), new EntrypointPatchBranding_1_8_9((EntrypointTransformer)it)));

    @Override
    public String getGameId() {
        return "minecraft";
    }

    @Override
    public String getGameName() {
        return "Minecraft";
    }

    @Override
    public String getRawGameVersion() {
        return this.versionData.raw;
    }

    @Override
    public String getNormalizedGameVersion() {
        return this.versionData.normalized;
    }

    @Override
    public Collection<GameProvider.BuiltinMod> getBuiltinMods() {
        URL url;
        try {
            url = this.gameJar.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return Arrays.asList(new GameProvider.BuiltinMod(url, new BuiltinModMetadata.Builder(this.getGameId(), this.getNormalizedGameVersion()).setName(this.getGameName()).build()));
    }

    @Override
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public Path getLaunchDirectory() {
        if (this.arguments == null) {
            return new File(".").toPath();
        }
        return FabricLauncherBase.getLaunchDirectory(this.arguments).toPath();
    }

    @Override
    public boolean isObfuscated() {
        return true;
    }

    @Override
    public boolean requiresUrlClassLoader() {
        return this.hasModLoader;
    }

    @Override
    public List<Path> getGameContextJars() {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(this.gameJar);
        if (this.realmsJar != null) {
            list.add(this.realmsJar);
        }
        return list;
    }

    @Override
    public boolean locateGame(EnvType envType, ClassLoader loader) {
        this.envType = envType;
        List<String> entrypointClasses = envType == EnvType.CLIENT ? Arrays.asList("net.minecraft.client.main.Main", "net.minecraft.client.MinecraftApplet", "com.mojang.minecraft.MinecraftApplet") : Arrays.asList("net.minecraft.server.MinecraftServer", "com.mojang.minecraft.server.MinecraftServer");
        Optional<GameProviderHelper.EntrypointResult> entrypointResult = GameProviderHelper.findFirstClass(loader, entrypointClasses);
        if (!entrypointResult.isPresent()) {
            return false;
        }
        this.entrypoint = entrypointResult.get().entrypointName;
        this.gameJar = entrypointResult.get().entrypointPath;
        this.realmsJar = GameProviderHelper.getSource(loader, "realmsVersion").orElse(null);
        this.hasModLoader = GameProviderHelper.getSource(loader, "ModLoader.class").isPresent();
        this.versionData = McVersionLookup.getVersion(this.gameJar);
        return true;
    }

    @Override
    public void acceptArguments(String ... argStrs) {
        this.arguments = new Arguments();
        this.arguments.parse(argStrs);
        FabricLauncherBase.processArgumentMap(this.arguments, this.envType);
    }

    @Override
    public EntrypointTransformer getEntrypointTransformer() {
        return TRANSFORMER;
    }

    @Override
    public boolean canOpenErrorGui() {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            return false;
        }
        if (this.arguments == null || this.envType == EnvType.CLIENT) {
            return true;
        }
        List<String> extras = this.arguments.getExtraArgs();
        return !extras.contains("nogui") && !extras.contains("--nogui");
    }

    @Override
    public void launch(ClassLoader loader) {
        String targetClass = this.entrypoint;
        if (this.envType == EnvType.CLIENT && targetClass.contains("Applet")) {
            targetClass = "net.fabricmc.loader.entrypoint.applet.AppletMain";
        }
        try {
            Class<?> c = loader.loadClass(targetClass);
            Method m = c.getMethod("main", String[].class);
            m.invoke(null, new Object[]{this.arguments.toArray()});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

