/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Feature;
import com.google.common.jimfs.Jimfs;
import com.google.common.jimfs.PathType;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.discovery.BuiltinMetadataWrapper;
import net.fabricmc.loader.discovery.ModCandidate;
import net.fabricmc.loader.discovery.ModCandidateFinder;
import net.fabricmc.loader.discovery.ModCandidateSet;
import net.fabricmc.loader.discovery.ModResolutionException;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.ModMetadataParser;
import net.fabricmc.loader.metadata.NestedJarEntry;
import net.fabricmc.loader.util.FileSystemUtil;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.fabricmc.loader.util.sat4j.core.VecInt;
import net.fabricmc.loader.util.sat4j.minisat.SolverFactory;
import net.fabricmc.loader.util.sat4j.specs.ContradictionException;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.TimeoutException;
import org.apache.logging.log4j.Logger;

public class ModResolver {
    private static final FileSystem inMemoryFs = Jimfs.newFileSystem((String)"nestedJarStore", (Configuration)Configuration.builder((PathType)PathType.unix()).setRoots("/", new String[0]).setWorkingDirectory("/").setAttributeViews("basic", new String[0]).setSupportedFeatures(new Feature[]{Feature.SECURE_DIRECTORY_STREAM, Feature.FILE_CHANNEL}).build());
    private static final Map<URL, List<Path>> inMemoryCache = new ConcurrentHashMap<URL, List<Path>>();
    private static final Pattern MOD_ID_PATTERN = Pattern.compile("[a-z][a-z0-9-_]{1,63}");
    private static final Object launcherSyncObject = new Object();
    private final List<ModCandidateFinder> candidateFinders = new ArrayList<ModCandidateFinder>();

    public void addCandidateFinder(ModCandidateFinder f) {
        this.candidateFinders.add(f);
    }

    private static IVecInt toVecInt(IntStream stream) {
        return new VecInt(stream.toArray());
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, ModCandidate> findCompatibleSet(Logger logger, Map<String, ModCandidateSet> modCandidateSetMap) throws ModResolutionException {
        HashMap<String, ModCandidate> result;
        boolean isAdvanced = false;
        HashMap<String, Collection<ModCandidate>> modCandidateMap = new HashMap<String, Collection<ModCandidate>>();
        HashSet<String> mandatoryMods = new HashSet<String>();
        for (ModCandidateSet modCandidateSet : modCandidateSetMap.values()) {
            Object s = modCandidateSet.toSortedSet();
            modCandidateMap.put(modCandidateSet.getModId(), (Collection<ModCandidate>)s);
            isAdvanced |= s.size() > 1 || ((ModCandidate)s.iterator().next()).getDepth() > 0;
            if (!modCandidateSet.isUserProvided()) continue;
            mandatoryMods.add(modCandidateSet.getModId());
        }
        if (!isAdvanced) {
            result = new HashMap<String, ModCandidate>();
            for (Object s : modCandidateMap.keySet()) {
                result.put((String)s, (ModCandidate)((Collection)modCandidateMap.get(s)).iterator().next());
            }
        } else {
            void var7_10;
            boolean bl = true;
            HashMap candidateIntMap = new HashMap();
            ArrayList<ModCandidate> intCandidateMap = new ArrayList<ModCandidate>(modCandidateMap.size() * 2);
            intCandidateMap.add(null);
            for (Iterator m : modCandidateMap.values()) {
                Iterator iterator = m.iterator();
                while (iterator.hasNext()) {
                    ModCandidate candidate = (ModCandidate)iterator.next();
                    candidateIntMap.put(candidate, (int)(++var7_10));
                    intCandidateMap.add(candidate);
                }
            }
            ISolver solver = SolverFactory.newLight();
            solver.newVar((int)var7_10);
            try {
                for (String id : modCandidateMap.keySet()) {
                    IVecInt versionVec = ModResolver.toVecInt(((Collection)modCandidateMap.get(id)).stream().mapToInt(candidateIntMap::get));
                    try {
                        if (mandatoryMods.contains(id)) {
                            solver.addExactly(versionVec, 1);
                            continue;
                        }
                        solver.addAtMost(versionVec, 1);
                    }
                    catch (ContradictionException e) {
                        throw new ModResolutionException("Could not resolve valid mod collection (at: adding mod " + id + ")", e);
                    }
                }
                for (ModCandidate mod : candidateIntMap.keySet()) {
                    int[] matchingCandidates;
                    int modClauseId = (Integer)candidateIntMap.get(mod);
                    for (ModDependency dep : mod.getInfo().getDepends()) {
                        matchingCandidates = ((Collection)modCandidateMap.getOrDefault(dep.getModId(), Collections.emptyList())).stream().filter(c -> dep.matches(c.getInfo().getVersion())).mapToInt(candidateIntMap::get).toArray();
                        int[] clause = new int[matchingCandidates.length + 1];
                        System.arraycopy(matchingCandidates, 0, clause, 0, matchingCandidates.length);
                        clause[matchingCandidates.length] = -modClauseId;
                        try {
                            solver.addClause((IVecInt)new VecInt(clause));
                        }
                        catch (ContradictionException e) {
                            throw new ModResolutionException("Could not find required mod: " + mod.getInfo().getId() + " requires " + dep, e);
                        }
                    }
                    for (ModDependency dep : mod.getInfo().getBreaks()) {
                        matchingCandidates = ((Collection)modCandidateMap.getOrDefault(dep.getModId(), Collections.emptyList())).stream().filter(c -> dep.matches(c.getInfo().getVersion())).mapToInt(candidateIntMap::get).toArray();
                        try {
                            for (int m : matchingCandidates) {
                                solver.addClause((IVecInt)new VecInt(new int[]{-modClauseId, -m}));
                            }
                        }
                        catch (ContradictionException e) {
                            throw new ModResolutionException("Found conflicting mods: " + mod.getInfo().getId() + " breaks " + dep, e);
                        }
                    }
                }
                Object problem = solver;
                Object assumptions = new VecInt(modCandidateMap.size());
                for (String mod : modCandidateMap.keySet()) {
                    int pos = assumptions.size();
                    assumptions = assumptions.push(0);
                    Collection candidates = (Collection)modCandidateMap.get(mod);
                    boolean satisfied = false;
                    for (ModCandidate candidate : candidates) {
                        assumptions.set(pos, ((Integer)candidateIntMap.get(candidate)).intValue());
                        if (!problem.isSatisfiable((IVecInt)assumptions)) continue;
                        satisfied = true;
                        break;
                    }
                    if (satisfied) continue;
                    if (mandatoryMods.contains(mod)) {
                        throw new ModResolutionException("Could not resolve mod collection including mandatory mod '" + mod + "'");
                    }
                    assumptions = assumptions.pop();
                }
                int[] model = problem.model();
                result = new HashMap();
                for (int i : model) {
                    if (i <= 0) continue;
                    ModCandidate candidate = (ModCandidate)intCandidateMap.get(i);
                    if (result.containsKey(candidate.getInfo().getId())) {
                        throw new ModResolutionException("Duplicate ID '" + candidate.getInfo().getId() + "' after solving - wrong constraints?");
                    }
                    result.put(candidate.getInfo().getId(), candidate);
                }
            }
            catch (TimeoutException e) {
                throw new ModResolutionException("Mod collection took too long to be resolved", e);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String m : mandatoryMods) {
            if (result.keySet().contains(m)) continue;
            hashSet.add(m);
        }
        StringBuilder errorsHard = new StringBuilder();
        StringBuilder errorsSoft = new StringBuilder();
        if (!hashSet.isEmpty()) {
            errorsHard.append("\n - Missing mods: ").append(String.join((CharSequence)", ", hashSet));
        } else {
            for (ModCandidate candidate : result.values()) {
                for (ModDependency dependency : candidate.getInfo().getDepends()) {
                    this.addErrorToList(candidate, dependency, result, errorsHard, "depends on", true);
                }
                for (ModDependency dependency : candidate.getInfo().getRecommends()) {
                    this.addErrorToList(candidate, dependency, result, errorsSoft, "recommends", true);
                }
                for (ModDependency dependency : candidate.getInfo().getBreaks()) {
                    this.addErrorToList(candidate, dependency, result, errorsHard, "breaks", false);
                }
                for (ModDependency dependency : candidate.getInfo().getConflicts()) {
                    this.addErrorToList(candidate, dependency, result, errorsSoft, "conflicts with", false);
                }
                Version version = candidate.getInfo().getVersion();
                ArrayList<Version> suspiciousVersions = new ArrayList<Version>();
                Object object = ((Collection)modCandidateMap.get(candidate.getInfo().getId())).iterator();
                while (object.hasNext()) {
                    ModCandidate other = (ModCandidate)object.next();
                    Version otherVersion = other.getInfo().getVersion();
                    if (!(version instanceof Comparable) || !(otherVersion instanceof Comparable) || version.equals(otherVersion) || ((Comparable)((Object)version)).compareTo(otherVersion) != 0) continue;
                    suspiciousVersions.add(otherVersion);
                }
                if (suspiciousVersions.isEmpty()) continue;
                errorsSoft.append("\n - Conflicting versions found for ").append(candidate.getInfo().getId()).append(": used ").append(version.getFriendlyString()).append(", also found ").append(suspiciousVersions.stream().map(Version::getFriendlyString).collect(Collectors.joining(", ")));
            }
        }
        String errHardStr = errorsHard.toString();
        String errSoftStr = errorsSoft.toString();
        if (!errSoftStr.isEmpty()) {
            logger.warn("Warnings were found! " + errSoftStr);
        }
        if (!errHardStr.isEmpty()) {
            throw new ModResolutionException("Errors were found!" + errHardStr + errSoftStr);
        }
        return result;
    }

    private void addErrorToList(ModCandidate candidate, ModDependency dependency, Map<String, ModCandidate> result, StringBuilder errors, String errorType, boolean cond) {
        boolean isPresent;
        String depModId = dependency.getModId();
        StringBuilder prefix = new StringBuilder("\n - Mod ").append(candidate.getInfo().getId());
        prefix.append(" ").append(errorType).append(" mod ").append(depModId);
        ArrayList<String> errorList = new ArrayList<String>();
        if (!ModResolver.isModIdValid(depModId, errorList)) {
            if (errorList.size() == 1) {
                errors.append((CharSequence)prefix).append(" which has an invalid mod id because it ").append((String)errorList.get(0));
            } else {
                errors.append((CharSequence)prefix).append(" which has an invalid mod because:");
                for (String error : errorList) {
                    errors.append("\n   - It ").append(error);
                }
            }
            return;
        }
        ModCandidate depCandidate = result.get(depModId);
        boolean bl = isPresent = depCandidate == null ? false : dependency.matches(depCandidate.getInfo().getVersion());
        if (isPresent != cond) {
            errors.append("\n - Mod ").append(candidate.getInfo().getId()).append(" ").append(errorType).append(" mod ").append(dependency).append(", ");
            if (depCandidate == null) {
                errors.append("which is missing");
            } else if (cond) {
                errors.append("but a different version is present: ").append(depCandidate.getInfo().getVersion());
            } else if (errorType.contains("conf")) {
                errors.append("but the conflicting version is present: ").append(depCandidate.getInfo().getVersion());
            } else {
                errors.append("but the breaking version is present: ").append(depCandidate.getInfo().getVersion());
            }
            errors.append("!");
        }
    }

    private static boolean isModIdValid(String modId, List<String> errorList) {
        if (modId.isEmpty()) {
            errorList.add("is empty!");
            return false;
        }
        if (modId.length() == 1) {
            errorList.add("is only a single character! (It must be at least 2 characters long)!");
        } else if (modId.length() > 64) {
            errorList.add("has more than 64 characters!");
        }
        char first = modId.charAt(0);
        if (first < 'a' || first > 'z') {
            errorList.add("starts with an invalid character '" + first + "' (it must be a lowercase a-z - upper case isn't allowed anywhere in the ID)");
        }
        HashSet<Character> invalidChars = null;
        for (int i = 1; i < modId.length(); ++i) {
            char c = modId.charAt(i);
            if (c == '-' || c == '_' || '0' <= c && c <= '9' || 'a' <= c && c <= 'z') continue;
            if (invalidChars == null) {
                invalidChars = new HashSet<Character>();
            }
            invalidChars.add(Character.valueOf(c));
        }
        if (invalidChars != null) {
            StringBuilder error = new StringBuilder("contains invalid characters: '");
            Object[] chars = invalidChars.toArray(new Character[0]);
            Arrays.sort(chars);
            for (Object c : chars) {
                error.append(((Character)c).charValue());
            }
            errorList.add(error.append("'!").toString());
        }
        assert (errorList.isEmpty() == MOD_ID_PATTERN.matcher(modId).matches()) : "Errors list " + errorList + " didn't match the mod ID pattern!";
        return errorList.isEmpty();
    }

    public Map<String, ModCandidate> resolve(FabricLoader loader) throws ModResolutionException {
        ConcurrentHashMap<String, ModCandidateSet> candidatesById = new ConcurrentHashMap<String, ModCandidateSet>();
        long time1 = System.currentTimeMillis();
        ConcurrentLinkedQueue allActions = new ConcurrentLinkedQueue();
        ForkJoinPool pool = new ForkJoinPool(Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
        for (ModCandidateFinder f : this.candidateFinders) {
            f.findCandidates(loader, u -> {
                UrlProcessAction action = new UrlProcessAction(loader, (Map<String, ModCandidateSet>)candidatesById, (URL)u, 0);
                allActions.add(action);
                pool.execute(action);
            });
        }
        for (GameProvider.BuiltinMod mod : loader.getGameProvider().getBuiltinMods()) {
            candidatesById.computeIfAbsent(mod.metadata.getId(), ModCandidateSet::new).add(new ModCandidate(new BuiltinMetadataWrapper(mod.metadata), mod.url, 0));
        }
        boolean tookTooLong = false;
        Throwable exception = null;
        try {
            pool.shutdown();
            pool.awaitTermination(30L, TimeUnit.SECONDS);
            for (UrlProcessAction action : allActions) {
                if (!action.isDone()) {
                    tookTooLong = true;
                    continue;
                }
                Throwable t = action.getException();
                if (t == null) continue;
                if (exception == null) {
                    exception = t;
                    continue;
                }
                exception.addSuppressed(t);
            }
        }
        catch (InterruptedException e) {
            throw new ModResolutionException("Mod resolution took too long!", e);
        }
        if (tookTooLong) {
            throw new ModResolutionException("Mod resolution took too long!");
        }
        if (exception != null) {
            throw new ModResolutionException("Mod resolution failed!", exception);
        }
        long time2 = System.currentTimeMillis();
        Map<String, ModCandidate> result = this.findCompatibleSet(loader.getLogger(), candidatesById);
        long time3 = System.currentTimeMillis();
        loader.getLogger().debug("Mod resolution detection time: " + (time2 - time1) + "ms");
        loader.getLogger().debug("Mod resolution time: " + (time3 - time2) + "ms");
        for (ModCandidate candidate : result.values()) {
            if (candidate.getInfo().getSchemaVersion() < 1) {
                loader.getLogger().warn("Mod ID " + candidate.getInfo().getId() + " uses outdated schema version: " + candidate.getInfo().getSchemaVersion() + " < " + 1);
            }
            candidate.getInfo().emitFormatWarnings(loader.getLogger());
        }
        return result;
    }

    static class UrlProcessAction
    extends RecursiveAction {
        private final FabricLoader loader;
        private final Map<String, ModCandidateSet> candidatesById;
        private final URL url;
        private final int depth;

        UrlProcessAction(FabricLoader loader, Map<String, ModCandidateSet> candidatesById, URL url, int depth) {
            this.loader = loader;
            this.candidatesById = candidatesById;
            this.url = url;
            this.depth = depth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void compute() {
            LoaderModMetadata[] info;
            Path rootDir;
            Path modJson;
            URL normalizedUrl;
            Path path;
            this.loader.getLogger().debug("Testing " + this.url);
            try {
                path = UrlUtil.asPath(this.url).normalize();
                normalizedUrl = UrlUtil.asUrl(path);
            }
            catch (UrlConversionException e) {
                throw new RuntimeException("Failed to convert URL " + this.url + "!", e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                modJson = path.resolve("fabric.mod.json");
                rootDir = path;
                if (this.loader.isDevelopmentEnvironment() && !Files.exists(modJson, new LinkOption[0])) {
                    this.loader.getLogger().warn("Adding directory " + path + " to mod classpath in development environment - workaround for Gradle splitting mods into two directories");
                    Object e = launcherSyncObject;
                    synchronized (e) {
                        FabricLauncherBase.getLauncher().propose(this.url);
                    }
                }
            } else {
                try {
                    FileSystemUtil.FileSystemDelegate jarFs = FileSystemUtil.getJarFileSystem(path, false);
                    modJson = jarFs.get().getPath("fabric.mod.json", new String[0]);
                    rootDir = jarFs.get().getRootDirectories().iterator().next();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open mod JAR at " + path + "!");
                }
            }
            try (InputStream stream = Files.newInputStream(modJson, new OpenOption[0]);){
                info = ModMetadataParser.getMods(this.loader, stream);
            }
            catch (JsonSyntaxException e) {
                throw new RuntimeException("Mod at '" + path + "' has an invalid fabric.mod.json file!", e);
            }
            catch (NoSuchFileException e) {
                info = new LoaderModMetadata[]{};
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to open fabric.mod.json for mod at '" + path + "'!", e);
            }
            for (LoaderModMetadata i : info) {
                ModCandidate candidate = new ModCandidate(i, normalizedUrl, this.depth);
                if (candidate.getInfo().getId() == null || candidate.getInfo().getId().isEmpty()) {
                    throw new RuntimeException(String.format("Mod file `%s` has no id", candidate.getOriginUrl().getFile()));
                }
                if (!MOD_ID_PATTERN.matcher(candidate.getInfo().getId()).matches()) {
                    ArrayList errorList = new ArrayList();
                    ModResolver.isModIdValid(candidate.getInfo().getId(), errorList);
                    StringBuilder fullError = new StringBuilder("Mod id `");
                    fullError.append(candidate.getInfo().getId()).append("` does not match the requirements because");
                    if (errorList.size() == 1) {
                        fullError.append(" it ").append((String)errorList.get(0));
                    } else {
                        fullError.append(":");
                        for (String error : errorList) {
                            fullError.append("\n  - It ").append(error);
                        }
                    }
                    throw new RuntimeException(fullError.toString());
                }
                boolean added = this.candidatesById.computeIfAbsent(candidate.getInfo().getId(), ModCandidateSet::new).add(candidate);
                if (!added) {
                    this.loader.getLogger().debug(candidate.getOriginUrl() + " already present as " + candidate);
                    continue;
                }
                this.loader.getLogger().debug("Adding " + candidate.getOriginUrl() + " as " + candidate);
                List jarInJars = inMemoryCache.computeIfAbsent(candidate.getOriginUrl(), u -> {
                    this.loader.getLogger().debug("Searching for nested JARs in " + candidate);
                    Collection<NestedJarEntry> jars = candidate.getInfo().getJars();
                    ArrayList list = new ArrayList(jars.size());
                    jars.stream().map(j -> rootDir.resolve(j.getFile().replace("/", rootDir.getFileSystem().getSeparator()))).forEach(modPath -> {
                        if (!Files.isDirectory(modPath, new LinkOption[0]) && modPath.toString().endsWith(".jar")) {
                            this.loader.getLogger().debug("Found nested JAR: " + modPath);
                            Path dest = inMemoryFs.getPath(UUID.randomUUID() + ".jar", new String[0]);
                            try {
                                Files.copy(modPath, dest, new CopyOption[0]);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to load nested JAR " + modPath + " into memory (" + dest + ")!", e);
                            }
                            list.add(dest);
                        }
                    });
                    return list;
                });
                if (jarInJars.isEmpty()) continue;
                UrlProcessAction.invokeAll(jarInJars.stream().map(p -> {
                    try {
                        return new UrlProcessAction(this.loader, this.candidatesById, UrlUtil.asUrl(p.normalize()), this.depth + 1);
                    }
                    catch (UrlConversionException e) {
                        throw new RuntimeException("Failed to turn path '" + p.normalize() + "' into URL!", e);
                    }
                }).collect(Collectors.toList()));
            }
        }
    }
}

