/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.transformer;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.game.MinecraftGameProvider;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.transformer.ClassStripper;
import net.fabricmc.loader.transformer.EnvironmentStrippingData;
import net.fabricmc.loader.transformer.PackageAccessFixer;
import net.fabricmc.loader.transformer.accesswidener.AccessWidenerVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public final class FabricTransformer {
    public static byte[] fixGuava(byte[] bytes) {
        ClassWriter writer = new ClassWriter(0);
        new ClassReader(bytes).accept(new ClassVisitor(458752, (ClassVisitor)writer){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        if (owner.equals("com/google/common/base/Objects") && name.equals("firstNonNull") && descriptor.equals("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")) {
                            owner = "com/google/common/base/MoreObjects";
                        } else if (owner.equals("com/google/common/collect/Iterators") && name.equals("emptyIterator")) {
                            owner = "net/fabricmc/loader/guava/IteratorsFix";
                            name = "emptyListIterator";
                            descriptor = "()Lcom/google/common/collect/UnmodifiableListIterator;";
                        }
                        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                    }
                };
            }
        }, 0);
        return writer.toByteArray();
    }

    public static byte[] lwTransformerHook(String name, String transformedName, byte[] bytes) {
        bytes = FabricTransformer.fixGuava(bytes);
        boolean isDevelopment = FabricLauncherBase.getLauncher().isDevelopment();
        EnvType envType = FabricLauncherBase.getLauncher().getEnvironmentType();
        byte[] input = MinecraftGameProvider.TRANSFORMER.transform(name);
        if (input != null) {
            return FabricTransformer.transform(isDevelopment, envType, name, input);
        }
        if (bytes != null) {
            return FabricTransformer.transform(isDevelopment, envType, name, bytes);
        }
        return null;
    }

    public static byte[] transform(boolean isDevelopment, EnvType envType, String name, byte[] bytes) {
        ClassWriter classWriter;
        boolean applyAccessWidener;
        bytes = FabricTransformer.fixGuava(bytes);
        boolean isMinecraftClass = name.startsWith("net.minecraft.") || name.indexOf(46) < 0;
        boolean transformAccess = isMinecraftClass && FabricLauncherBase.getLauncher().getMappingConfiguration().requiresPackageAccessHack();
        boolean environmentStrip = !isMinecraftClass || isDevelopment;
        boolean bl = applyAccessWidener = isMinecraftClass && FabricLoader.INSTANCE.getAccessWidener().getTargets().contains(name);
        if (!(transformAccess || environmentStrip || applyAccessWidener)) {
            return bytes;
        }
        ClassReader classReader = new ClassReader(bytes);
        Object visitor = classWriter = new ClassWriter(0);
        int visitorCount = 0;
        if (applyAccessWidener) {
            visitor = new AccessWidenerVisitor(524288, (ClassVisitor)visitor, FabricLoader.INSTANCE.getAccessWidener());
            ++visitorCount;
        }
        if (transformAccess) {
            visitor = new PackageAccessFixer(524288, (ClassVisitor)visitor);
            ++visitorCount;
        }
        if (environmentStrip) {
            EnvironmentStrippingData stripData = new EnvironmentStrippingData(524288, envType.toString());
            classReader.accept((ClassVisitor)stripData, 5);
            if (stripData.stripEntireClass()) {
                throw new RuntimeException("Cannot load class " + name + " in environment type " + (Object)((Object)envType));
            }
            if (!stripData.isEmpty()) {
                visitor = new ClassStripper(524288, (ClassVisitor)visitor, stripData.getStripInterfaces(), stripData.getStripFields(), stripData.getStripMethods());
                ++visitorCount;
            }
        }
        if (visitorCount <= 0) {
            return bytes;
        }
        classReader.accept((ClassVisitor)visitor, 0);
        return classWriter.toByteArray();
    }
}

