/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.version;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.util.version.SemanticVersionImpl;
import net.fabricmc.loader.util.version.StringVersion;
import net.fabricmc.loader.util.version.VersionParsingException;

public class VersionDeserializer
implements JsonDeserializer<Version> {
    public static SemanticVersion deserializeSemantic(String s) throws VersionParsingException {
        if (s == null || s.isEmpty()) {
            throw new VersionParsingException("Version must be a non-empty string!");
        }
        return new SemanticVersionImpl(s, false);
    }

    public static Version deserialize(String s) throws VersionParsingException {
        Version version;
        if (s == null || s.isEmpty()) {
            throw new VersionParsingException("Version must be a non-empty string!");
        }
        try {
            version = new SemanticVersionImpl(s, false);
        }
        catch (VersionParsingException e) {
            version = new StringVersion(s);
        }
        return version;
    }

    public Version deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonPrimitive()) {
            throw new JsonParseException("Version must be a non-empty string!");
        }
        String s = json.getAsString();
        try {
            return VersionDeserializer.deserialize(s);
        }
        catch (VersionParsingException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

