/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.discovery.ModCandidate;
import net.fabricmc.loader.discovery.ModResolutionException;

public class ModCandidateSet {
    private final String modId;
    private final Set<ModCandidate> depthZeroCandidates = new HashSet<ModCandidate>();
    private final Map<String, ModCandidate> candidates = new HashMap<String, ModCandidate>();

    private static int compare(ModCandidate a, ModCandidate b) {
        Version av = a.getInfo().getVersion();
        Version bv = b.getInfo().getVersion();
        if (av instanceof Comparable && bv instanceof Comparable) {
            return ((Comparable)((Object)bv)).compareTo(av);
        }
        return 0;
    }

    public ModCandidateSet(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean add(ModCandidate candidate) {
        String version = candidate.getInfo().getVersion().getFriendlyString();
        ModCandidate oldCandidate = this.candidates.get(version);
        if (oldCandidate != null) {
            int newDepth;
            int oldDepth = oldCandidate.getDepth();
            if (oldDepth <= (newDepth = candidate.getDepth())) {
                return false;
            }
            this.candidates.remove(version);
            if (oldDepth > 0) {
                this.depthZeroCandidates.remove(oldCandidate);
            }
        }
        this.candidates.put(version, candidate);
        if (candidate.getDepth() == 0) {
            this.depthZeroCandidates.add(candidate);
        }
        return true;
    }

    public boolean isUserProvided() {
        return !this.depthZeroCandidates.isEmpty();
    }

    public Collection<ModCandidate> toSortedSet() throws ModResolutionException {
        if (this.depthZeroCandidates.size() > 1) {
            String modVersions = this.depthZeroCandidates.stream().map(c -> "[" + c.getInfo().getVersion() + " at " + c.getOriginUrl().getFile() + "]").collect(Collectors.joining(", "));
            throw new ModResolutionException("Duplicate versions for mod ID '" + this.modId + "': " + modVersions);
        }
        if (this.depthZeroCandidates.size() == 1) {
            return this.depthZeroCandidates;
        }
        if (this.candidates.size() > 1) {
            ArrayList<ModCandidate> out = new ArrayList<ModCandidate>(this.candidates.values());
            out.sort(ModCandidateSet::compare);
            return out;
        }
        return Collections.singleton(this.candidates.values().iterator().next());
    }
}

