/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.gui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class FabricStatusTree {
    public static final String ICON_TYPE_DEFAULT = "";
    public static final String ICON_TYPE_FOLDER = "folder";
    public static final String ICON_TYPE_UNKNOWN_FILE = "file";
    public static final String ICON_TYPE_JAR_FILE = "jar";
    public static final String ICON_TYPE_FABRIC_JAR_FILE = "jar+fabric";
    public static final String ICON_TYPE_FABRIC = "fabric";
    public static final String ICON_TYPE_JSON = "json";
    public static final String ICON_TYPE_FABRIC_JSON = "json+fabric";
    public static final String ICON_TYPE_JAVA_CLASS = "java_class";
    public static final String ICON_TYPE_PACKAGE = "package";
    public static final String ICON_TYPE_JAVA_PACKAGE = "java_package";
    public static final String ICON_TYPE_TICK = "tick";
    public static final String ICON_TYPE_LESSER_CROSS = "lesser_cross";
    public final List<FabricStatusTab> tabs = new ArrayList<FabricStatusTab>();
    public final List<FabricStatusButton> buttons = new ArrayList<FabricStatusButton>();
    public String mainText = null;

    public FabricStatusTab addTab(String name) {
        FabricStatusTab tab = new FabricStatusTab(name);
        this.tabs.add(tab);
        return tab;
    }

    public FabricStatusButton addButton(String text) {
        FabricStatusButton button = new FabricStatusButton(text);
        this.buttons.add(button);
        return button;
    }

    public static final class FabricStatusNode {
        private FabricStatusNode parent;
        public String name;
        public String iconType = "";
        private FabricTreeWarningLevel warningLevel = FabricTreeWarningLevel.NONE;
        public boolean expandByDefault = false;
        public final List<FabricStatusNode> children = new ArrayList<FabricStatusNode>();
        public String details;

        private FabricStatusNode(FabricStatusNode parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public void moveTo(FabricStatusNode newParent) {
            this.parent.children.remove(this);
            this.parent = newParent;
            newParent.children.add(this);
        }

        public FabricTreeWarningLevel getMaximumWarningLevel() {
            return this.warningLevel;
        }

        public void setWarningLevel(FabricTreeWarningLevel level) {
            if (this.warningLevel == level) {
                return;
            }
            if (this.warningLevel.isHigherThan(level)) {
                throw new Error("Why would you set the warning level multiple times?");
            }
            if (this.parent != null && level.isHigherThan(this.parent.warningLevel)) {
                this.parent.setWarningLevel(level);
            }
            this.warningLevel = level;
        }

        public void setError() {
            this.setWarningLevel(FabricTreeWarningLevel.ERROR);
        }

        public void setWarning() {
            this.setWarningLevel(FabricTreeWarningLevel.WARN);
        }

        public void setInfo() {
            this.setWarningLevel(FabricTreeWarningLevel.INFO);
        }

        public FabricStatusNode addChild(String string) {
            FabricStatusNode child = new FabricStatusNode(this, string);
            this.children.add(child);
            return child;
        }

        public FabricStatusNode addException(Throwable exception) {
            FabricStatusNode sub = new FabricStatusNode(this, "...");
            this.children.add(sub);
            sub.setError();
            String msg = exception.getMessage();
            String[] lines = (msg == null ? exception.toString() : msg).split("\n");
            if (lines.length == 0) {
                sub.name = exception.toString();
            } else {
                sub.name = lines[0];
                for (int i = 1; i < lines.length; ++i) {
                    sub.addChild(lines[i]);
                }
            }
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            sub.details = sw.toString();
            return sub;
        }

        public void mergeWithSingleChild(String join) {
            if (this.children.size() != 1) {
                return;
            }
            FabricStatusNode child = this.children.remove(0);
            this.name = this.name + join + child.name;
            for (FabricStatusNode cc : child.children) {
                cc.parent = this;
                this.children.add(cc);
            }
            child.children.clear();
        }

        public void mergeSingleChildFilePath(String folderType) {
            if (!this.iconType.equals(folderType)) {
                return;
            }
            while (this.children.size() == 1 && this.children.get((int)0).iconType.equals(folderType)) {
                this.mergeWithSingleChild("/");
            }
            this.children.sort((a, b) -> a.name.compareTo(b.name));
            this.mergeChildFilePaths(folderType);
        }

        public void mergeChildFilePaths(String folderType) {
            for (FabricStatusNode node : this.children) {
                node.mergeSingleChildFilePath(folderType);
            }
        }

        public FabricStatusNode getFileNode(String file, String folderType, String fileType) {
            FabricStatusNode fileNode = this;
            block0: for (String s : file.split("/")) {
                if (s.isEmpty()) continue;
                for (FabricStatusNode c : fileNode.children) {
                    if (!c.name.equals(s)) continue;
                    fileNode = c;
                    continue block0;
                }
                if (fileNode.iconType.equals(FabricStatusTree.ICON_TYPE_DEFAULT)) {
                    fileNode.iconType = folderType;
                }
                fileNode = fileNode.addChild(s);
            }
            fileNode.iconType = fileType;
            return fileNode;
        }
    }

    public static final class FabricStatusTab {
        public final FabricStatusNode node;
        public FabricTreeWarningLevel filterLevel = FabricTreeWarningLevel.NONE;

        public FabricStatusTab(String name) {
            this.node = new FabricStatusNode(null, name);
        }

        public FabricStatusNode addChild(String name) {
            return this.node.addChild(name);
        }
    }

    public static final class FabricStatusButton {
        public final String text;
        public boolean shouldClose;
        public boolean shouldContinue;

        public FabricStatusButton(String text) {
            this.text = text;
        }

        public FabricStatusButton makeClose() {
            this.shouldClose = true;
            return this;
        }

        public FabricStatusButton makeContinue() {
            this.shouldContinue = true;
            return this;
        }
    }

    public static enum FabricBasicButtonType {
        CLICK_ONCE;

    }

    public static enum FabricTreeWarningLevel {
        ERROR,
        WARN,
        INFO,
        NONE;

        public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);

        public boolean isHigherThan(FabricTreeWarningLevel other) {
            return this.ordinal() < other.ordinal();
        }

        public boolean isAtLeast(FabricTreeWarningLevel other) {
            return this.ordinal() <= other.ordinal();
        }

        public static FabricTreeWarningLevel getHighest(FabricTreeWarningLevel a, FabricTreeWarningLevel b) {
            return a.isHigherThan(b) ? a : b;
        }
    }
}

