/*
 * Copyright 2016 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.loader.api;

import net.fabricmc.loader.api.metadata.ModMetadata;

import java.nio.file.Path;

public interface ModContainer {
	ModMetadata getMetadata();

	@Deprecated
	default Path getRoot() {
		return getRootPath();
	}

	Path getRootPath();

	/**
	 * Get an NIO reference to a file inside the JAR.
	 * Does not guarantee existence!
	 *
	 * @param file The location from root, using "/" as a separator.
	 * @return The Path to a given file.
	 */
	default Path getPath(String file) {
		Path root = getRootPath();
		return root.resolve(file.replace("/", root.getFileSystem().getSeparator()));
	}
}
