/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.api;

import java.util.Optional;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.util.version.VersionDeserializer;
import net.fabricmc.loader.util.version.VersionParsingException;

public interface SemanticVersion
extends Version,
Comparable<SemanticVersion> {
    public static final int COMPONENT_WILDCARD = Integer.MIN_VALUE;

    public int getVersionComponentCount();

    public int getVersionComponent(int var1);

    public Optional<String> getPrereleaseKey();

    public Optional<String> getBuildKey();

    public boolean hasWildcard();

    @Override
    default public int compareTo(SemanticVersion o) {
        for (int i = 0; i < Math.max(this.getVersionComponentCount(), o.getVersionComponentCount()); ++i) {
            int compare;
            int first = this.getVersionComponent(i);
            int second = o.getVersionComponent(i);
            if (first == Integer.MIN_VALUE || second == Integer.MIN_VALUE || (compare = Integer.compare(first, second)) == 0) continue;
            return compare;
        }
        Optional<String> prereleaseA = this.getPrereleaseKey();
        Optional<String> prereleaseB = o.getPrereleaseKey();
        if (prereleaseA.isPresent() || prereleaseB.isPresent()) {
            if (prereleaseA.isPresent() && prereleaseB.isPresent()) {
                return prereleaseA.get().compareTo(prereleaseB.get());
            }
            if (prereleaseA.isPresent()) {
                return o.hasWildcard() ? 0 : -1;
            }
            return this.hasWildcard() ? 0 : 1;
        }
        return 0;
    }

    public static SemanticVersion parse(String s) throws VersionParsingException {
        return VersionDeserializer.deserializeSemantic(s);
    }
}

