/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.entrypoint.minecraft;

import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.entrypoint.EntrypointPatch;
import net.fabricmc.loader.entrypoint.EntrypointTransformer;
import net.fabricmc.loader.launch.common.FabricLauncher;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntrypointPatchHook
extends EntrypointPatch {
    public EntrypointPatchHook(EntrypointTransformer transformer) {
        super(transformer);
    }

    private void finishEntrypoint(EnvType type, ListIterator<AbstractInsnNode> it) {
        it.add((AbstractInsnNode)new MethodInsnNode(184, "net/fabricmc/loader/entrypoint/minecraft/hooks/Entrypoint" + (type == EnvType.CLIENT ? "Client" : "Server"), "start", "(Ljava/io/File;Ljava/lang/Object;)V", false));
    }

    @Override
    public void process(FabricLauncher launcher, Consumer<ClassNode> classEmitter) {
        EnvType type = launcher.getEnvironmentType();
        String entrypoint = launcher.getEntrypoint();
        if (!entrypoint.startsWith("net.minecraft.") && !entrypoint.startsWith("com.mojang.")) {
            return;
        }
        try {
            ClassNode gameClass;
            List<FieldNode> newGameFields;
            String gameEntrypoint = null;
            boolean serverHasFile = true;
            boolean isApplet = entrypoint.contains("Applet");
            ClassNode mainClass = this.loadClass(launcher, entrypoint);
            if (mainClass == null) {
                throw new RuntimeException("Could not load main class " + entrypoint + "!");
            }
            boolean is20w22aServerOrHigher = false;
            if (type == EnvType.CLIENT && (newGameFields = this.findFields(mainClass, f -> !this.isStatic(f.access) && f.desc.startsWith("L") && !f.desc.startsWith("Ljava/"))).size() == 1) {
                gameEntrypoint = Type.getType((String)newGameFields.get((int)0).desc).getClassName();
            }
            if (gameEntrypoint == null) {
                MethodInsnNode newGameInsn;
                MethodNode mainMethod = this.findMethod(mainClass, method -> method.name.equals("main") && method.desc.equals("([Ljava/lang/String;)V") && this.isPublicStatic(method.access));
                if (mainMethod == null) {
                    throw new RuntimeException("Could not find main method in " + entrypoint + "!");
                }
                if (type == EnvType.SERVER && (newGameInsn = (MethodInsnNode)this.findInsn(mainMethod, insn -> insn.getOpcode() == 183 && ((MethodInsnNode)insn).name.equals("<init>") && ((MethodInsnNode)insn).owner.equals(mainClass.name), false)) != null) {
                    gameEntrypoint = newGameInsn.owner.replace('/', '.');
                    serverHasFile = newGameInsn.desc.startsWith("(Ljava/io/File;");
                }
                if (gameEntrypoint == null) {
                    newGameInsn = (MethodInsnNode)this.findInsn(mainMethod, type == EnvType.CLIENT ? insn -> (insn.getOpcode() == 183 || insn.getOpcode() == 182) && !((MethodInsnNode)insn).owner.startsWith("java/") : insn -> insn.getOpcode() == 183 && ((MethodInsnNode)insn).name.equals("<init>") && this.hasSuperClass(((MethodInsnNode)insn).owner, mainClass.name, launcher), true);
                    if (newGameInsn == null && type == EnvType.SERVER) {
                        newGameInsn = (MethodInsnNode)this.findInsn(mainMethod, insn -> insn instanceof MethodInsnNode && insn.getOpcode() == 183 && this.hasStrInMethod(((MethodInsnNode)insn).owner, "<clinit>", "()V", "^[a-fA-F0-9]{40}$", launcher), false);
                    }
                    if (type == EnvType.SERVER && this.hasStrInMethod(mainClass.name, mainMethod.name, mainMethod.desc, "Safe mode active, only vanilla datapack will be loaded", launcher)) {
                        is20w22aServerOrHigher = true;
                        gameEntrypoint = mainClass.name;
                    }
                    if (newGameInsn != null) {
                        gameEntrypoint = newGameInsn.owner.replace('/', '.');
                        serverHasFile = newGameInsn.desc.startsWith("(Ljava/io/File;");
                    }
                }
            }
            if (gameEntrypoint == null) {
                throw new RuntimeException("Could not find game constructor in " + entrypoint + "!");
            }
            this.debug("Found game constructor: " + entrypoint + " -> " + gameEntrypoint);
            ClassNode classNode = gameClass = gameEntrypoint.equals(entrypoint) || is20w22aServerOrHigher ? mainClass : this.loadClass(launcher, gameEntrypoint);
            if (gameClass == null) {
                throw new RuntimeException("Could not load game class " + gameEntrypoint + "!");
            }
            MethodNode gameMethod = null;
            MethodNode gameConstructor = null;
            AbstractInsnNode lwjglLogNode = null;
            int gameMethodQuality = 0;
            if (!is20w22aServerOrHigher) {
                for (MethodNode gmCandidate : gameClass.methods) {
                    if (gmCandidate.name.equals("<init>")) {
                        gameConstructor = gmCandidate;
                        if (gameMethodQuality < 1) {
                            gameMethod = gmCandidate;
                            gameMethodQuality = 1;
                        }
                    }
                    if (type != EnvType.CLIENT || isApplet || gameMethodQuality >= 2) continue;
                    int qual = 2;
                    boolean hasLwjglLog = false;
                    for (AbstractInsnNode insn2 : gmCandidate.instructions) {
                        String s;
                        Object cst;
                        if (!(insn2 instanceof LdcInsnNode) || !((cst = ((LdcInsnNode)insn2).cst) instanceof String) || !(s = (String)cst).startsWith("LWJGL Version: ") && !s.startsWith("Backend library: ")) continue;
                        hasLwjglLog = true;
                        if (!"LWJGL Version: ".equals(s) && !"LWJGL Version: {}".equals(s) && !"Backend library: {}".equals(s)) break;
                        qual = 3;
                        lwjglLogNode = insn2;
                        break;
                    }
                    if (!hasLwjglLog) continue;
                    gameMethod = gmCandidate;
                    gameMethodQuality = qual;
                }
            } else {
                gameMethod = this.findMethod(mainClass, method -> method.name.equals("main") && method.desc.equals("([Ljava/lang/String;)V") && this.isPublicStatic(method.access));
            }
            if (gameMethod == null) {
                throw new RuntimeException("Could not find game constructor method in " + gameClass.name + "!");
            }
            boolean patched = false;
            this.debug("Patching game constructor " + gameMethod.name + gameMethod.desc);
            if (type == EnvType.SERVER) {
                ListIterator it = gameMethod.instructions.iterator();
                if (!is20w22aServerOrHigher) {
                    this.moveBefore((ListIterator<AbstractInsnNode>)it, 177);
                    if (serverHasFile) {
                        it.add(new VarInsnNode(25, 1));
                    } else {
                        it.add(new InsnNode(1));
                    }
                    it.add(new VarInsnNode(25, 0));
                } else {
                    this.debug("20w22a+ detected, patching main method...");
                    LdcInsnNode safeModeLdc = (LdcInsnNode)this.findInsn(gameMethod, insn -> insn instanceof LdcInsnNode && ((LdcInsnNode)insn).cst.equals("Safe mode active, only vanilla datapack will be loaded"), false);
                    AbstractInsnNode node = safeModeLdc.getPrevious();
                    while (!(node instanceof JumpInsnNode)) {
                        node = node.getPrevious();
                    }
                    JumpInsnNode safeModeIfEq = (JumpInsnNode)node;
                    this.moveBefore((ListIterator<AbstractInsnNode>)it, safeModeIfEq.getPrevious());
                    it.add(new InsnNode(1));
                    it.add(new InsnNode(1));
                }
                this.finishEntrypoint(type, it);
                patched = true;
            } else if (type == EnvType.CLIENT && isApplet) {
                FieldNode runDirectory = this.findField(gameClass, f -> this.isStatic(f.access) && f.desc.equals("Ljava/io/File;"));
                if (runDirectory == null) {
                    this.warn("Could not find applet run directory! (If you're running pre-late-indev versions, this is fine.)");
                    ListIterator it = gameMethod.instructions.iterator();
                    if (gameConstructor == gameMethod) {
                        this.moveBefore((ListIterator<AbstractInsnNode>)it, 177);
                    }
                    it.add(new InsnNode(1));
                    it.add(new MethodInsnNode(184, "net/fabricmc/loader/entrypoint/applet/AppletMain", "hookGameDir", "(Ljava/io/File;)Ljava/io/File;", false));
                    it.add(new VarInsnNode(25, 0));
                    this.finishEntrypoint(type, it);
                } else {
                    ListIterator it = gameConstructor.instructions.iterator();
                    this.moveAfter((ListIterator<AbstractInsnNode>)it, 183);
                    it.add(new FieldInsnNode(178, gameClass.name, runDirectory.name, runDirectory.desc));
                    it.add(new MethodInsnNode(184, "net/fabricmc/loader/entrypoint/applet/AppletMain", "hookGameDir", "(Ljava/io/File;)Ljava/io/File;", false));
                    it.add(new FieldInsnNode(179, gameClass.name, runDirectory.name, runDirectory.desc));
                    it = gameMethod.instructions.iterator();
                    if (gameConstructor == gameMethod) {
                        this.moveBefore((ListIterator<AbstractInsnNode>)it, 177);
                    }
                    it.add(new FieldInsnNode(178, gameClass.name, runDirectory.name, runDirectory.desc));
                    it.add(new VarInsnNode(25, 0));
                    this.finishEntrypoint(type, it);
                }
                patched = true;
            } else {
                if (gameConstructor == null) {
                    throw new RuntimeException("Non-applet client-side, but could not find constructor?");
                }
                ListIterator consIt = gameConstructor.instructions.iterator();
                while (consIt.hasNext()) {
                    AbstractInsnNode insn3 = (AbstractInsnNode)consIt.next();
                    if (insn3.getOpcode() != 181 || !((FieldInsnNode)insn3).desc.equals("Ljava/io/File;")) continue;
                    this.debug("Run directory field is thought to be " + ((FieldInsnNode)insn3).owner + "/" + ((FieldInsnNode)insn3).name);
                    ListIterator it = gameMethod == gameConstructor ? consIt : gameMethod.instructions.iterator();
                    if (lwjglLogNode != null) {
                        this.moveBefore((ListIterator<AbstractInsnNode>)it, lwjglLogNode);
                        for (int i = 0; i < 4; ++i) {
                            this.moveBeforeType(it, 5);
                        }
                    }
                    it.add(new VarInsnNode(25, 0));
                    it.add(new FieldInsnNode(180, ((FieldInsnNode)insn3).owner, ((FieldInsnNode)insn3).name, ((FieldInsnNode)insn3).desc));
                    it.add(new VarInsnNode(25, 0));
                    this.finishEntrypoint(type, it);
                    patched = true;
                    break;
                }
            }
            if (!patched) {
                throw new RuntimeException("Game constructor patch not applied!");
            }
            if (gameClass != mainClass) {
                classEmitter.accept(gameClass);
            } else {
                classEmitter.accept(mainClass);
            }
            if (isApplet) {
                EntrypointTransformer.appletMainClass = entrypoint;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasSuperClass(String cls, String superCls, FabricLauncher launcher) {
        if (cls.contains("$") || !cls.startsWith("net/minecraft") && cls.contains("/")) {
            return false;
        }
        try {
            byte[] bytes = launcher.getClassByteArray(cls, false);
            ClassReader reader = new ClassReader(bytes);
            return reader.getSuperName().equals(superCls);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to check superclass of " + cls, e);
        }
    }

    private boolean hasStrInMethod(String cls, String methodName, String methodDesc, String str, FabricLauncher launcher) {
        if (cls.contains("$") || !cls.startsWith("net/minecraft") && cls.contains("/")) {
            return false;
        }
        try {
            byte[] bytes = launcher.getClassByteArray(cls, false);
            ClassReader reader = new ClassReader(bytes);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            for (MethodNode method : node.methods) {
                if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
                for (AbstractInsnNode insn : method.instructions) {
                    Object cst;
                    if (!(insn instanceof LdcInsnNode) || !((cst = ((LdcInsnNode)insn).cst) instanceof String) || !cst.equals(str)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find string in " + cls + methodName + methodDesc, e);
        }
    }
}

