/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.metadata.CustomValue;

abstract class CustomValueImpl
implements CustomValue {
    static final CustomValue BOOLEAN_TRUE = new BooleanImpl(true);
    static final CustomValue BOOLEAN_FALSE = new BooleanImpl(false);
    static final CustomValue NULL = new NullImpl();

    CustomValueImpl() {
    }

    public static CustomValue fromJsonElement(JsonElement e) {
        if (e instanceof JsonObject) {
            JsonObject o = (JsonObject)e;
            LinkedHashMap<String, CustomValue> entries = new LinkedHashMap<String, CustomValue>(o.entrySet().size());
            for (Map.Entry entry : o.entrySet()) {
                entries.put((String)entry.getKey(), CustomValueImpl.fromJsonElement((JsonElement)entry.getValue()));
            }
            return new ObjectImpl(entries);
        }
        if (e instanceof JsonArray) {
            JsonArray o = (JsonArray)e;
            ArrayList<CustomValue> entries = new ArrayList<CustomValue>(o.size());
            int max = o.size();
            for (int i = 0; i < max; ++i) {
                entries.add(CustomValueImpl.fromJsonElement(o.get(i)));
            }
            return new ArrayImpl(entries);
        }
        if (e instanceof JsonPrimitive) {
            JsonPrimitive o = (JsonPrimitive)e;
            if (o.isString()) {
                return new StringImpl(o.getAsString());
            }
            if (o.isNumber()) {
                return new NumberImpl(o.getAsNumber());
            }
            if (o.isBoolean()) {
                return o.getAsBoolean() ? BOOLEAN_TRUE : BOOLEAN_FALSE;
            }
            throw new IllegalStateException();
        }
        if (e instanceof JsonNull) {
            return NULL;
        }
        throw new IllegalArgumentException(Objects.toString(e));
    }

    @Override
    public final CustomValue.CvObject getAsObject() {
        if (this instanceof ObjectImpl) {
            return (ObjectImpl)this;
        }
        throw new ClassCastException("can't convert " + this.getType().name() + " to Object");
    }

    @Override
    public final CustomValue.CvArray getAsArray() {
        if (this instanceof ArrayImpl) {
            return (ArrayImpl)this;
        }
        throw new ClassCastException("can't convert " + this.getType().name() + " to Array");
    }

    @Override
    public final String getAsString() {
        if (this instanceof StringImpl) {
            return ((StringImpl)this).value;
        }
        throw new ClassCastException("can't convert " + this.getType().name() + " to String");
    }

    @Override
    public final Number getAsNumber() {
        if (this instanceof NumberImpl) {
            return ((NumberImpl)this).value;
        }
        throw new ClassCastException("can't convert " + this.getType().name() + " to Number");
    }

    @Override
    public final boolean getAsBoolean() {
        if (this instanceof BooleanImpl) {
            return ((BooleanImpl)this).value;
        }
        throw new ClassCastException("can't convert " + this.getType().name() + " to Boolean");
    }

    private static final class NullImpl
    extends CustomValueImpl {
        private NullImpl() {
        }

        @Override
        public CustomValue.CvType getType() {
            return CustomValue.CvType.NULL;
        }
    }

    private static final class BooleanImpl
    extends CustomValueImpl {
        final boolean value;

        public BooleanImpl(boolean value) {
            this.value = value;
        }

        @Override
        public CustomValue.CvType getType() {
            return CustomValue.CvType.BOOLEAN;
        }
    }

    private static final class NumberImpl
    extends CustomValueImpl {
        final Number value;

        public NumberImpl(Number value) {
            this.value = value;
        }

        @Override
        public CustomValue.CvType getType() {
            return CustomValue.CvType.NUMBER;
        }
    }

    private static final class StringImpl
    extends CustomValueImpl {
        final String value;

        public StringImpl(String value) {
            this.value = value;
        }

        @Override
        public CustomValue.CvType getType() {
            return CustomValue.CvType.STRING;
        }
    }

    private static final class ArrayImpl
    extends CustomValueImpl
    implements CustomValue.CvArray {
        private final List<CustomValue> entries;

        public ArrayImpl(List<CustomValue> entries) {
            this.entries = Collections.unmodifiableList(entries);
        }

        @Override
        public CustomValue.CvType getType() {
            return CustomValue.CvType.ARRAY;
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public CustomValue get(int index) {
            return this.entries.get(index);
        }

        @Override
        public Iterator<CustomValue> iterator() {
            return this.entries.iterator();
        }
    }

    private static final class ObjectImpl
    extends CustomValueImpl
    implements CustomValue.CvObject {
        private final Map<String, CustomValue> entries;

        public ObjectImpl(Map<String, CustomValue> entries) {
            this.entries = Collections.unmodifiableMap(entries);
        }

        @Override
        public CustomValue.CvType getType() {
            return CustomValue.CvType.OBJECT;
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public boolean containsKey(String key) {
            return this.entries.containsKey(key);
        }

        @Override
        public CustomValue get(String key) {
            return this.entries.get(key);
        }

        @Override
        public Iterator<Map.Entry<String, CustomValue>> iterator() {
            return this.entries.entrySet().iterator();
        }
    }
}

