/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.discovery.ModCandidateFinder;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;

public class ClasspathModCandidateFinder
implements ModCandidateFinder {
    @Override
    public void findCandidates(FabricLoader loader, Consumer<URL> appender) {
        Stream<URL> urls;
        if (FabricLauncherBase.getLauncher().isDevelopment()) {
            try {
                String[] classpathPropertyInput;
                Enumeration<URL> mods = FabricLauncherBase.getLauncher().getTargetClassLoader().getResources("fabric.mod.json");
                HashSet<URL> modsList = new HashSet<URL>();
                while (mods.hasMoreElements()) {
                    try {
                        modsList.add(UrlUtil.getSource("fabric.mod.json", mods.nextElement()));
                    }
                    catch (UrlConversionException e) {
                        loader.getLogger().debug((Object)e);
                    }
                }
                loader.getLogger().debug("[ClasspathModCandidateFinder] Adding dev classpath directories to classpath.");
                for (String s : classpathPropertyInput = System.getProperty("java.class.path", "").split(File.pathSeparator)) {
                    File file;
                    if (s.isEmpty() || s.equals("*") || s.endsWith(File.separator + "*") || !(file = new File(s)).exists() || !file.isDirectory()) continue;
                    try {
                        URL url2 = UrlUtil.asUrl(file);
                        if (modsList.contains(url2)) continue;
                        FabricLauncherBase.getLauncher().propose(url2);
                    }
                    catch (UrlConversionException e) {
                        loader.getLogger().warn("[ClasspathModCandidateFinder] Failed to add dev directory " + file.getAbsolutePath() + " to classpath!", (Throwable)e);
                    }
                }
                urls = modsList.stream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            urls = Stream.of(FabricLauncherBase.getLauncher().getClass().getProtectionDomain().getCodeSource().getLocation());
        }
        catch (Throwable t) {
            loader.getLogger().debug("Could not fallback to itself for mod candidate lookup!", t);
            urls = Stream.empty();
        }
        urls.forEach(url -> {
            File f;
            loader.getLogger().debug("[ClasspathModCandidateFinder] Processing " + url.getPath());
            try {
                f = UrlUtil.asFile(url);
            }
            catch (UrlConversionException e) {
                return;
            }
            if (f.exists() && (f.isDirectory() || f.getName().endsWith(".jar"))) {
                appender.accept((URL)url);
            }
        });
    }
}

