/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.discovery;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.discovery.ModCandidateFinder;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;

public class DirectoryModCandidateFinder
implements ModCandidateFinder {
    private final Path path;

    public DirectoryModCandidateFinder(Path path) {
        this.path = path;
    }

    @Override
    public void findCandidates(FabricLoader loader, Consumer<URL> urlProposer) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createDirectory(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create directory " + this.path, e);
            }
        }
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            throw new RuntimeException(this.path + " is not a directory!");
        }
        try {
            Files.walk(this.path, 1, FileVisitOption.FOLLOW_LINKS).forEach(modPath -> {
                if (!Files.isDirectory(modPath, new LinkOption[0]) && modPath.toString().endsWith(".jar")) {
                    try {
                        urlProposer.accept(UrlUtil.asUrl(modPath));
                    }
                    catch (UrlConversionException e) {
                        throw new RuntimeException("Failed to convert URL for mod '" + modPath + "'!", e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while searching for mods in '" + this.path + "'!", e);
        }
    }
}

