/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.gui;

import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.gui.FabricMainWindow;
import net.fabricmc.loader.gui.FabricStatusTree;

public final class FabricGuiEntry {
    public static void open(FabricStatusTree tree) throws Exception {
        FabricGuiEntry.openWindow(tree, true);
    }

    private static void openWindow(FabricStatusTree tree, boolean shouldWait) throws Exception {
        FabricMainWindow.open(tree, shouldWait);
    }

    public static void displayCriticalError(Throwable exception, boolean exitAfter) {
        FabricLoader.INSTANCE.getLogger().fatal("A critical error occurred", exception);
        GameProvider provider = FabricLoader.INSTANCE.getGameProvider();
        if ((provider == null || provider.canOpenErrorGui()) && !GraphicsEnvironment.isHeadless()) {
            FabricStatusTree tree = new FabricStatusTree();
            FabricStatusTree.FabricStatusTab crashTab = tree.addTab("Crash");
            tree.mainText = "Failed to launch!";
            FabricGuiEntry.addThrowable(crashTab.node, exception, new HashSet<Throwable>());
            tree.addButton("Exit").makeClose();
            try {
                FabricGuiEntry.open(tree);
            }
            catch (Exception e) {
                if (exitAfter) {
                    FabricLoader.INSTANCE.getLogger().warn("Failed to open the error gui!", (Throwable)e);
                }
                throw new RuntimeException("Failed to open the error gui!", e);
            }
        }
        if (exitAfter) {
            System.exit(1);
        }
    }

    private static void addThrowable(FabricStatusTree.FabricStatusNode node, Throwable e, Set<Throwable> seen) {
        Throwable cause;
        if (!seen.add(e)) {
            return;
        }
        while ((cause = e.getCause()) != null && e.getSuppressed().length <= 0) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
            if (!msg.equals(cause.getMessage()) && !msg.equals(cause.toString())) break;
            e = cause;
        }
        FabricStatusTree.FabricStatusNode sub = node.addException(e);
        if (e.getCause() != null) {
            FabricGuiEntry.addThrowable(sub, e.getCause(), seen);
        }
        for (Throwable t : e.getSuppressed()) {
            FabricGuiEntry.addThrowable(sub, t, seen);
        }
    }
}

