/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.knot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.entrypoint.minecraft.hooks.EntrypointUtils;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.game.GameProviders;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.common.FabricMixinBootstrap;
import net.fabricmc.loader.launch.knot.KnotClassLoader;
import net.fabricmc.loader.launch.knot.KnotClassLoaderInterface;
import net.fabricmc.loader.launch.knot.KnotCompatibilityClassLoader;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import org.spongepowered.asm.launch.MixinBootstrap;

public final class Knot
extends FabricLauncherBase {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    private KnotClassLoaderInterface classLoader;
    private boolean isDevelopment;
    private EnvType envType;
    private final File gameJarFile;
    private GameProvider provider;

    protected Knot(EnvType type, File gameJarFile) {
        this.envType = type;
        this.gameJarFile = gameJarFile;
    }

    protected void init(String[] args) {
        Knot.setProperties(this.properties);
        if (this.envType == null) {
            String side = System.getProperty("fabric.side");
            if (side == null) {
                throw new RuntimeException("Please specify side or use a dedicated Knot!");
            }
            switch (side.toLowerCase(Locale.ROOT)) {
                case "client": {
                    this.envType = EnvType.CLIENT;
                    break;
                }
                case "server": {
                    this.envType = EnvType.SERVER;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid side provided: must be \"client\" or \"server\"!");
                }
            }
        }
        List<GameProvider> providers = GameProviders.create();
        this.provider = null;
        for (GameProvider p : providers) {
            if (!p.locateGame(this.envType, this.getClass().getClassLoader())) continue;
            this.provider = p;
            break;
        }
        if (this.provider == null) {
            LOGGER.error("Could not find valid game provider!");
            for (GameProvider p : providers) {
                LOGGER.error("- " + p.getGameName() + " " + p.getRawGameVersion());
            }
            throw new RuntimeException("Could not find valid game provider!");
        }
        LOGGER.info("Loading for game " + this.provider.getGameName() + " " + this.provider.getRawGameVersion());
        this.provider.acceptArguments(args);
        this.isDevelopment = Boolean.parseBoolean(System.getProperty("fabric.development", "false"));
        boolean useCompatibility = this.provider.requiresUrlClassLoader() || Boolean.parseBoolean(System.getProperty("fabric.loader.useCompatibilityClassLoader", "false"));
        this.classLoader = useCompatibility ? new KnotCompatibilityClassLoader(this.isDevelopment(), this.envType, this.provider) : new KnotClassLoader(this.isDevelopment(), this.envType, this.provider);
        ClassLoader cl = (ClassLoader)((Object)this.classLoader);
        if (this.provider.isObfuscated()) {
            for (Path path : this.provider.getGameContextJars()) {
                FabricLauncherBase.deobfuscate(this.provider.getGameId(), this.provider.getNormalizedGameVersion(), this.provider.getLaunchDirectory(), path, this);
            }
        }
        this.provider.getEntrypointTransformer().locateEntrypoints(this);
        Thread.currentThread().setContextClassLoader(cl);
        FabricLoader loader = FabricLoader.INSTANCE;
        loader.setGameProvider(this.provider);
        loader.load();
        loader.freeze();
        FabricLoader.INSTANCE.getAccessWidener().loadFromMods();
        MixinBootstrap.init();
        FabricMixinBootstrap.init(this.getEnvironmentType(), loader);
        FabricLauncherBase.finishMixinBootstrapping();
        this.classLoader.getDelegate().initializeTransformers();
        EntrypointUtils.invoke("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
        this.provider.launch(cl);
    }

    @Override
    public String getTargetNamespace() {
        return this.isDevelopment ? "named" : "intermediary";
    }

    @Override
    public Collection<URL> getLoadTimeDependencies() {
        String cmdLineClasspath = System.getProperty("java.class.path");
        return Arrays.stream(cmdLineClasspath.split(File.pathSeparator)).filter(s -> {
            if (s.equals("*") || s.endsWith(File.separator + "*")) {
                System.err.println("WARNING: Knot does not support wildcard classpath entries: " + s + " - the game may not load properly!");
                return false;
            }
            return true;
        }).map(s -> {
            File file = new File((String)s);
            if (!file.equals(this.gameJarFile)) {
                try {
                    return UrlUtil.asUrl(file);
                }
                catch (UrlConversionException e) {
                    LOGGER.debug((Object)e);
                    return null;
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void propose(URL url) {
        FabricLauncherBase.LOGGER.debug("[Knot] Proposed " + url + " to classpath.");
        this.classLoader.addURL(url);
    }

    @Override
    public EnvType getEnvironmentType() {
        return this.envType;
    }

    @Override
    public boolean isClassLoaded(String name) {
        return this.classLoader.isClassLoaded(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            return this.classLoader.getResourceAsStream(name, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file '" + name + "'!", e);
        }
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return (ClassLoader)((Object)this.classLoader);
    }

    @Override
    public byte[] getClassByteArray(String name, boolean runTransformers) throws IOException {
        if (runTransformers) {
            return this.classLoader.getDelegate().getPreMixinClassByteArray(name, false);
        }
        return this.classLoader.getDelegate().getRawClassByteArray(name, false);
    }

    @Override
    public boolean isDevelopment() {
        return this.isDevelopment;
    }

    @Override
    public String getEntrypoint() {
        return this.provider.getEntrypoint();
    }

    public static void main(String[] args) {
        new Knot(null, null).init(args);
    }
}

