/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.server;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

class InjectingURLClassLoader
extends URLClassLoader {
    private final List<String> exclusions;

    InjectingURLClassLoader(URL[] urls, ClassLoader classLoader, String ... exclusions) {
        super(urls, classLoader);
        this.exclusions = Arrays.asList(exclusions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                boolean excluded = false;
                for (String s : this.exclusions) {
                    if (!name.startsWith(s)) continue;
                    excluded = true;
                    break;
                }
                if (!excluded) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (c == null) {
                c = this.getParent().loadClass(name);
            }
            if (c == null) {
                throw new ClassNotFoundException(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

