/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.metadata.AbstractModMetadata;
import net.fabricmc.loader.metadata.CustomValueImpl;
import net.fabricmc.loader.metadata.EntrypointMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.MapBackedContactInformation;
import net.fabricmc.loader.metadata.NestedJarEntry;
import net.fabricmc.loader.util.version.VersionPredicateParser;
import org.apache.logging.log4j.Logger;

public class ModMetadataV1
extends AbstractModMetadata
implements LoaderModMetadata {
    private String id;
    private Version version;
    private ModEnvironment environment = ModEnvironment.UNIVERSAL;
    private EntrypointContainer entrypoints = new EntrypointContainer();
    private JarEntry[] jars = new JarEntry[0];
    private MixinEntry[] mixins = new MixinEntry[0];
    private String accessWidener;
    private DependencyContainer depends = new DependencyContainer();
    private DependencyContainer recommends = new DependencyContainer();
    private DependencyContainer suggests = new DependencyContainer();
    private DependencyContainer conflicts = new DependencyContainer();
    private DependencyContainer breaks = new DependencyContainer();
    private String name;
    private String description = "";
    private Person[] authors = new Person[0];
    private Person[] contributors = new Person[0];
    private Map<String, String> contact = new HashMap<String, String>();
    private LicenseEntry license = new LicenseEntry();
    private IconEntry icon = new IconEntry();
    private Map<String, String> languageAdapters = new HashMap<String, String>();
    private CustomValueContainer custom = new CustomValueContainer();
    @Deprecated
    private DependencyContainer requires = new DependencyContainer();

    @Override
    public String getType() {
        return "fabric";
    }

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    @Override
    public Map<String, String> getLanguageAdapterDefinitions() {
        return this.languageAdapters;
    }

    @Override
    public Collection<NestedJarEntry> getJars() {
        return Arrays.asList(this.jars);
    }

    @Override
    public Collection<String> getOldInitializers() {
        return Collections.emptyList();
    }

    @Override
    public List<EntrypointMetadata> getEntrypoints(String type) {
        List<EntrypointMetadata> list = (List<EntrypointMetadata>)this.entrypoints.metadataMap.get(type);
        return list != null ? list : Collections.emptyList();
    }

    @Override
    public Collection<String> getEntrypointKeys() {
        return this.entrypoints.metadataMap.keySet();
    }

    @Override
    public void emitFormatWarnings(Logger logger) {
        if (!this.requires.dependencies.isEmpty()) {
            logger.warn("Mod `" + this.id + "` (" + this.version + ") uses 'requires' key in fabric.mod.json, which is not supported - use 'depends'");
        }
    }

    @Override
    public Collection<String> getMixinConfigs(EnvType type) {
        return Arrays.asList(this.mixins).stream().filter(e -> ((MixinEntry)e).environment.matches(type)).map(e -> ((MixinEntry)e).config).collect(Collectors.toList());
    }

    @Override
    public String getAccessWidener() {
        return this.accessWidener;
    }

    @Override
    public boolean loadsInEnvironment(EnvType type) {
        return this.environment.matches(type);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.isEmpty()) {
            return this.id;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<net.fabricmc.loader.api.metadata.Person> getAuthors() {
        return Arrays.asList(this.authors);
    }

    @Override
    public Collection<net.fabricmc.loader.api.metadata.Person> getContributors() {
        return Arrays.asList(this.contributors);
    }

    @Override
    public ContactInformation getContact() {
        return new MapBackedContactInformation(this.contact);
    }

    @Override
    public Collection<String> getLicense() {
        return this.license.entries;
    }

    @Override
    public Optional<String> getIconPath(int size) {
        if (this.icon.iconMap != null && !this.icon.iconMap.isEmpty()) {
            int i;
            int iconValue = -1;
            Iterator iterator = this.icon.iconMap.keySet().iterator();
            while (iterator.hasNext() && (iconValue = (i = ((Integer)iterator.next()).intValue())) < size) {
            }
            return Optional.of(this.icon.iconMap.get(iconValue));
        }
        return Optional.ofNullable(this.icon.icon);
    }

    @Override
    public Map<String, CustomValue> getCustomValues() {
        return this.custom.getCustomValues();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ModEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public Collection<ModDependency> getDepends() {
        return this.depends.dependencies;
    }

    @Override
    public Collection<ModDependency> getRecommends() {
        return this.recommends.dependencies;
    }

    @Override
    public Collection<ModDependency> getSuggests() {
        return this.suggests.dependencies;
    }

    @Override
    public Collection<ModDependency> getConflicts() {
        return this.conflicts.dependencies;
    }

    @Override
    public Collection<ModDependency> getBreaks() {
        return this.breaks.dependencies;
    }

    public static class CustomValueContainer {
        private final Map<String, CustomValue> customValues;

        public CustomValueContainer() {
            this.customValues = Collections.emptyMap();
        }

        public CustomValueContainer(Map<String, CustomValue> customValues) {
            this.customValues = Collections.unmodifiableMap(customValues);
        }

        private Map<String, CustomValue> getCustomValues() {
            return this.customValues;
        }

        public static class Deserializer
        implements JsonDeserializer<CustomValueContainer> {
            public CustomValueContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Custom values must be in an object!");
                }
                HashMap<String, CustomValue> customValues = new HashMap<String, CustomValue>();
                Set entries = json.getAsJsonObject().entrySet();
                for (Map.Entry entry : entries) {
                    customValues.put((String)entry.getKey(), CustomValueImpl.fromJsonElement((JsonElement)entry.getValue()));
                }
                return new CustomValueContainer(customValues);
            }
        }
    }

    public static class EnvironmentDeserializer
    implements JsonDeserializer<ModEnvironment> {
        public ModEnvironment deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            String s = element.getAsString().toLowerCase(Locale.ROOT);
            if (s.isEmpty() || s.equals("*")) {
                return ModEnvironment.UNIVERSAL;
            }
            if (s.equals("client")) {
                return ModEnvironment.CLIENT;
            }
            if (s.equals("server")) {
                return ModEnvironment.SERVER;
            }
            throw new JsonParseException("Invalid environment type: " + s + "!");
        }
    }

    public static class LicenseEntry {
        private final List<String> entries = new ArrayList<String>();

        public static class Deserializer
        implements JsonDeserializer<LicenseEntry> {
            public LicenseEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                LicenseEntry entry = new LicenseEntry();
                if (json.isJsonArray()) {
                    json.getAsJsonArray().forEach(e -> entry.entries.add(e.getAsString()));
                } else if (json.isJsonPrimitive()) {
                    entry.entries.add(json.getAsString());
                } else {
                    throw new JsonParseException("License must be a string or array of strings!");
                }
                return entry;
            }
        }
    }

    public static class MixinEntry {
        private String config;
        private ModEnvironment environment = ModEnvironment.UNIVERSAL;

        public static class Deserializer
        implements JsonDeserializer<MixinEntry> {
            public MixinEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                MixinEntry entry = new MixinEntry();
                if (json.isJsonPrimitive()) {
                    entry.config = json.getAsString();
                } else if (json.isJsonObject()) {
                    JsonObject obj = json.getAsJsonObject();
                    if (!obj.has("config")) {
                        throw new JsonParseException("Missing mandatory key 'config' in mixin entry!");
                    }
                    entry.config = obj.get("config").getAsString();
                    if (obj.has("environment")) {
                        entry.environment = (ModEnvironment)((Object)context.deserialize(obj.get("environment"), ModEnvironment.class));
                    }
                } else {
                    throw new JsonParseException("Invalid type for mixin entry!");
                }
                return entry;
            }
        }
    }

    public static class EntrypointContainer {
        private final Map<String, List<EntrypointMetadata>> metadataMap = new HashMap<String, List<EntrypointMetadata>>();

        public static class Deserializer
        implements JsonDeserializer<EntrypointContainer> {
            public EntrypointContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Entrypoints must be an object!");
                }
                JsonObject obj = json.getAsJsonObject();
                EntrypointContainer ctr = new EntrypointContainer();
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    ArrayList<Metadata> metadata = new ArrayList<Metadata>();
                    if (((JsonElement)entry.getValue()).isJsonArray()) {
                        for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                            if (element.isJsonObject()) {
                                JsonObject entObj = element.getAsJsonObject();
                                String adapter = entObj.has("adapter") ? entObj.get("adapter").getAsString() : "default";
                                String value = entObj.get("value").getAsString();
                                metadata.add(new Metadata(adapter, value));
                                continue;
                            }
                            metadata.add(new Metadata("default", element.getAsString()));
                        }
                    } else {
                        throw new JsonParseException("Entrypoint list must be an array!");
                    }
                    if (metadata.isEmpty()) continue;
                    ctr.metadataMap.computeIfAbsent(key, t -> new ArrayList()).addAll(metadata);
                }
                return ctr;
            }
        }

        static class Metadata
        implements EntrypointMetadata {
            private final String adapter;
            private final String value;

            Metadata(String adapter, String value) {
                this.adapter = adapter;
                this.value = value;
            }

            @Override
            public String getAdapter() {
                return this.adapter;
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }

    public static class IconEntry {
        private String icon;
        private SortedMap<Integer, String> iconMap;

        public static class Deserializer
        implements JsonDeserializer<IconEntry> {
            public IconEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                IconEntry entry = new IconEntry();
                if (json.isJsonPrimitive()) {
                    entry.icon = json.getAsString();
                } else if (json.isJsonObject()) {
                    entry.iconMap = new TreeMap(Comparator.naturalOrder());
                    JsonObject obj = json.getAsJsonObject();
                    for (Map.Entry e : obj.entrySet()) {
                        int size;
                        try {
                            size = Integer.parseInt((String)e.getKey());
                        }
                        catch (NumberFormatException ex) {
                            throw new JsonParseException("Could not parse icon size '" + (String)e.getKey() + "'!", (Throwable)ex);
                        }
                        if (size < 1) {
                            throw new JsonParseException("Size must be positive!");
                        }
                        if (!((JsonElement)e.getValue()).isJsonPrimitive()) {
                            throw new JsonParseException("Icon value must be a string!");
                        }
                        entry.iconMap.put(size, ((JsonElement)e.getValue()).getAsString());
                    }
                    if (entry.iconMap.isEmpty()) {
                        throw new JsonParseException("Icon object must not be empty!");
                    }
                } else {
                    throw new JsonParseException("Icon entry must be an object or string!");
                }
                return entry;
            }
        }
    }

    public static class JarEntry
    implements NestedJarEntry {
        private String file;

        @Override
        public String getFile() {
            return this.file;
        }

        public static class Deserializer
        implements JsonDeserializer<JarEntry> {
            public JarEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj;
                JarEntry entry = new JarEntry();
                if (json.isJsonObject()) {
                    obj = json.getAsJsonObject();
                    if (!obj.has("file")) {
                        throw new JsonParseException("Missing mandatory key 'file' in JAR entry!");
                    }
                } else {
                    throw new JsonParseException("Invalid type for JAR entry!");
                }
                entry.file = obj.get("file").getAsString();
                return entry;
            }
        }
    }

    public static class Person
    implements net.fabricmc.loader.api.metadata.Person {
        private String name;
        private MapBackedContactInformation contact = new MapBackedContactInformation(Collections.emptyMap());

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ContactInformation getContact() {
            return this.contact;
        }

        public static class Deserializer
        implements JsonDeserializer<Person> {
            public Person deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Person person = new Person();
                if (json.isJsonObject()) {
                    JsonObject obj = json.getAsJsonObject();
                    if (!obj.has("name")) {
                        throw new JsonParseException("Person object must have a 'name' field!");
                    }
                    person.name = obj.get("name").getAsString();
                    if (obj.has("contact")) {
                        person.contact = new MapBackedContactInformation((Map)context.deserialize(obj.get("contact"), new TypeToken<HashMap<String, String>>(){}.getType()));
                    }
                } else if (json.isJsonPrimitive()) {
                    person.name = json.getAsString();
                } else {
                    throw new JsonParseException("Person type must be an object or string!");
                }
                return person;
            }
        }
    }

    public static class DependencyContainer {
        private final Map<String, List<String>> matcherStrings = new HashMap<String, List<String>>();
        private final List<ModDependency> dependencies = new ArrayList<ModDependency>();

        public static class Deserializer
        implements JsonDeserializer<DependencyContainer> {
            public DependencyContainer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new RuntimeException("Dependency container must be an object!");
                }
                DependencyContainer ctr = new DependencyContainer();
                JsonObject obj = json.getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    final ArrayList<String> matcherStringList = new ArrayList<String>();
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        matcherStringList.add(((JsonElement)entry.getValue()).getAsString());
                    } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                        JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                        array.forEach(e -> matcherStringList.add(e.getAsString()));
                    } else {
                        throw new RuntimeException("Dependency version range must be a string or string array!");
                    }
                    final String id = (String)entry.getKey();
                    ctr.matcherStrings.put(id, matcherStringList);
                    StringBuilder builder = new StringBuilder("{");
                    builder.append(id);
                    builder.append(" @ [");
                    for (int i = 0; i < matcherStringList.size(); ++i) {
                        if (i > 0) {
                            builder.append(" || ");
                        }
                        builder.append((String)matcherStringList.get(i));
                    }
                    builder.append("]}");
                    final String depAsStr = builder.toString();
                    ctr.dependencies.add(new ModDependency(){

                        @Override
                        public String getModId() {
                            return id;
                        }

                        @Override
                        public boolean matches(Version version) {
                            for (String s : matcherStringList) {
                                try {
                                    if (!VersionPredicateParser.matches(version, s)) continue;
                                    return true;
                                }
                                catch (VersionParsingException e) {
                                    e.printStackTrace();
                                    return false;
                                }
                            }
                            return false;
                        }

                        public String toString() {
                            return depAsStr;
                        }
                    });
                }
                return ctr;
            }
        }
    }
}

