/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.transformer.accesswidener;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.mappings.EntryTriple;

public class AccessWidener {
    public String namespace;
    public Map<String, Access> classAccess = new HashMap<String, Access>();
    public Map<EntryTriple, Access> methodAccess = new HashMap<EntryTriple, Access>();
    public Map<EntryTriple, Access> fieldAccess = new HashMap<EntryTriple, Access>();
    private Set<String> classes = new LinkedHashSet<String>();
    private final FabricLoader fabricLoader;

    public AccessWidener(FabricLoader fabricLoader) {
        this.fabricLoader = fabricLoader;
    }

    public void loadFromMods() {
        for (ModContainer modContainer : this.fabricLoader.getAllMods()) {
            LoaderModMetadata modMetadata = (LoaderModMetadata)modContainer.getMetadata();
            String accessWidener = modMetadata.getAccessWidener();
            if (accessWidener == null) continue;
            Path path = modContainer.getPath(accessWidener);
            try {
                BufferedReader reader = Files.newBufferedReader(path);
                Throwable throwable = null;
                try {
                    this.read(reader, this.fabricLoader.getMappingResolver().getCurrentRuntimeNamespace());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read accessWidener file from mod " + modMetadata.getId(), e);
            }
        }
    }

    public void read(BufferedReader reader, String currentNamespace) throws IOException {
        String line;
        String[] header = reader.readLine().split("\\s+");
        if (header.length != 3 || !header[0].equals("accessWidener")) {
            throw new UnsupportedOperationException("Invalid access access widener file");
        }
        if (!header[1].equals("v1")) {
            throw new RuntimeException(String.format("Unsupported access widener format (%s)", header[1]));
        }
        if (!header[2].equals(currentNamespace)) {
            throw new RuntimeException(String.format("Namespace (%s) does not match current runtime namespace (%s)", header[2], currentNamespace));
        }
        if (this.namespace != null && !this.namespace.equals(header[2])) {
            throw new RuntimeException(String.format("Namespace mismatch, expected %s got %s", this.namespace, header[2]));
        }
        this.namespace = header[2];
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        block10: while ((line = reader.readLine()) != null) {
            int commentPos = line.indexOf(35);
            if (commentPos >= 0) {
                line = line.substring(0, commentPos).trim();
            }
            if (line.isEmpty()) continue;
            String[] split = line.split("\\s+");
            if (split.length != 3 && split.length != 5) {
                throw new RuntimeException(String.format("Invalid line (%s)", line));
            }
            String access = split[0];
            targets.add(split[2].replaceAll("/", "."));
            switch (split[1]) {
                case "class": {
                    if (split.length != 3) {
                        throw new RuntimeException(String.format("Expected (<access>\tclass\t<className>) got (%s)", line));
                    }
                    this.classAccess.put(split[2], this.applyAccess(access, this.classAccess.getOrDefault(split[2], ClassAccess.DEFAULT), null));
                    continue block10;
                }
                case "field": {
                    if (split.length != 5) {
                        throw new RuntimeException(String.format("Expected (<access>\tfield\t<className>\t<fieldName>\t<fieldDesc>) got (%s)", line));
                    }
                    this.addOrMerge(this.fieldAccess, new EntryTriple(split[2], split[3], split[4]), access, FieldAccess.DEFAULT);
                    continue block10;
                }
                case "method": {
                    if (split.length != 5) {
                        throw new RuntimeException(String.format("Expected (<access>\tmethod\t<className>\t<methodName>\t<methodDesc>) got (%s)", line));
                    }
                    this.addOrMerge(this.methodAccess, new EntryTriple(split[2], split[3], split[4]), access, MethodAccess.DEFAULT);
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Unsupported type " + split[1]);
        }
        LinkedHashSet<String> parentClasses = new LinkedHashSet<String>();
        for (String clazz : targets) {
            while (clazz.contains("$")) {
                clazz = clazz.substring(0, clazz.lastIndexOf("$"));
                parentClasses.add(clazz);
            }
        }
        this.classes.addAll(targets);
        this.classes.addAll(parentClasses);
    }

    void addOrMerge(Map<EntryTriple, Access> map, EntryTriple entry, String access, Access defaultAccess) {
        if (entry == null || access == null) {
            throw new RuntimeException("Input entry or access is null");
        }
        map.put(entry, this.applyAccess(access, map.getOrDefault(entry, defaultAccess), entry));
    }

    private Access applyAccess(String input, Access access, EntryTriple entryTriple) {
        switch (input.toLowerCase(Locale.ROOT)) {
            case "accessible": {
                this.makeClassAccessible(entryTriple);
                return access.makeAccessible();
            }
            case "extendable": {
                this.makeClassExtendable(entryTriple);
                return access.makeExtendable();
            }
            case "mutable": {
                return access.makeMutable();
            }
        }
        throw new UnsupportedOperationException("Unknown access type:" + input);
    }

    private void makeClassAccessible(EntryTriple entryTriple) {
        if (entryTriple == null) {
            return;
        }
        this.classAccess.put(entryTriple.getOwner(), this.applyAccess("accessible", this.classAccess.getOrDefault(entryTriple.getOwner(), ClassAccess.DEFAULT), null));
    }

    private void makeClassExtendable(EntryTriple entryTriple) {
        if (entryTriple == null) {
            return;
        }
        this.classAccess.put(entryTriple.getOwner(), this.applyAccess("extendable", this.classAccess.getOrDefault(entryTriple.getOwner(), ClassAccess.DEFAULT), null));
    }

    public Access getClassAccess(String className) {
        return this.classAccess.getOrDefault(className, ClassAccess.DEFAULT);
    }

    public Access getFieldAccess(EntryTriple entryTriple) {
        return this.fieldAccess.getOrDefault(entryTriple, FieldAccess.DEFAULT);
    }

    public Access getMethodAccess(EntryTriple entryTriple) {
        return this.methodAccess.getOrDefault(entryTriple, MethodAccess.DEFAULT);
    }

    public Set<String> getTargets() {
        return this.classes;
    }

    private static int makePublic(int i) {
        return i & 0xFFFFFFF9 | 1;
    }

    private static int makeProtected(int i) {
        if ((i & 1) != 0) {
            return i;
        }
        return i & 0xFFFFFFFD | 4;
    }

    private static int makeFinalIfPrivate(int access, String name, int ownerAccess) {
        if (name.equals("<init>")) {
            return access;
        }
        if ((ownerAccess & 0x200) != 0 || (access & 8) != 0) {
            return access;
        }
        if ((access & 2) != 0) {
            return access | 0x10;
        }
        return access;
    }

    private static int removeFinal(int i) {
        return i & 0xFFFFFFEF;
    }

    @FunctionalInterface
    public static interface AccessOperator {
        public int apply(int var1, String var2, int var3);
    }

    public static enum FieldAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(access)),
        MUTABLE((access, name, ownerAccess) -> AccessWidener.access$000(access)),
        ACCESSIBLE_MUTABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private FieldAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == MUTABLE || this == ACCESSIBLE_MUTABLE) {
                return ACCESSIBLE_MUTABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            throw new UnsupportedOperationException("Fields cannot be made extendable");
        }

        @Override
        public Access makeMutable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_MUTABLE) {
                return ACCESSIBLE_MUTABLE;
            }
            return MUTABLE;
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    public static enum MethodAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.makeFinalIfPrivate(access, name, ownerAccess))),
        EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$200(AccessWidener.removeFinal(access))),
        ACCESSIBLE_EXTENDABLE((access, name, owner) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private MethodAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == EXTENDABLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return EXTENDABLE;
        }

        @Override
        public Access makeMutable() {
            throw new UnsupportedOperationException("Methods cannot be made mutable");
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    public static enum ClassAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(access)),
        EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access))),
        ACCESSIBLE_EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private ClassAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == EXTENDABLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return EXTENDABLE;
        }

        @Override
        public Access makeMutable() {
            throw new UnsupportedOperationException("Classes cannot be made mutable");
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    public static interface Access
    extends AccessOperator {
        public Access makeAccessible();

        public Access makeExtendable();

        public Access makeMutable();
    }
}

