/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.entrypoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.loader.entrypoint.EntrypointPatch;
import net.fabricmc.loader.launch.common.FabricLauncher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class EntrypointTransformer {
    public static String appletMainClass;
    public final Logger logger = LogManager.getFormatterLogger((String)"FabricLoader|EntrypointTransformer");
    private final List<EntrypointPatch> patches;
    private Map<String, byte[]> patchedClasses;
    private boolean entrypointsLocated = false;

    public EntrypointTransformer(Function<EntrypointTransformer, List<EntrypointPatch>> patches) {
        this.patches = patches.apply(this);
    }

    ClassNode loadClass(FabricLauncher launcher, String className) throws IOException {
        byte[] data;
        byte[] byArray = data = this.patchedClasses.containsKey(className) ? this.patchedClasses.get(className) : launcher.getClassByteArray(className, true);
        if (data != null) {
            ClassReader reader = new ClassReader(data);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            return node;
        }
        return null;
    }

    private void addPatchedClass(ClassNode node) {
        String key = node.name.replace('/', '.');
        if (this.patchedClasses.containsKey(key)) {
            throw new RuntimeException("Duplicate addPatchedClasses call: " + key);
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        this.patchedClasses.put(key, writer.toByteArray());
    }

    public void locateEntrypoints(FabricLauncher launcher) {
        if (this.entrypointsLocated) {
            return;
        }
        this.entrypointsLocated = true;
        this.patchedClasses = new HashMap<String, byte[]>();
        this.patches.forEach(e -> e.process(launcher, this::addPatchedClass));
        this.logger.debug("[EntrypointTransformer] Patched " + (this.patchedClasses.size() == 1 ? "1 class." : this.patchedClasses.size() + " classes."));
    }

    public byte[] transform(String className) {
        return this.patchedClasses.get(className);
    }
}

