/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.version;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.util.version.SemanticVersionImpl;

public final class SemanticVersionPredicateParser {
    private static final Map<String, Function<SemanticVersionImpl, Predicate<SemanticVersionImpl>>> PREFIXES = new LinkedHashMap<String, Function<SemanticVersionImpl, Predicate<SemanticVersionImpl>>>();

    public static Predicate<SemanticVersionImpl> create(String text) throws VersionParsingException {
        ArrayList<Predicate<SemanticVersionImpl>> predicateList = new ArrayList<Predicate<SemanticVersionImpl>>();
        ArrayList<SemanticVersionImpl> prereleaseVersions = new ArrayList<SemanticVersionImpl>();
        for (String s2 : text.split(" ")) {
            SemanticVersionImpl version;
            if ((s2 = s2.trim()).isEmpty() || s2.equals("*")) continue;
            Function<SemanticVersionImpl, Predicate<SemanticVersionImpl>> factory = null;
            for (String prefix : PREFIXES.keySet()) {
                if (!s2.startsWith(prefix)) continue;
                factory = PREFIXES.get(prefix);
                s2 = s2.substring(prefix.length());
                break;
            }
            if ((version = new SemanticVersionImpl(s2, true)).isPrerelease()) {
                prereleaseVersions.add(version);
            }
            if (factory == null) {
                factory = PREFIXES.get("=");
            } else if (version.hasWildcard()) {
                throw new VersionParsingException("Prefixed ranges are not allowed to use X-ranges!");
            }
            predicateList.add(factory.apply(version));
        }
        if (predicateList.isEmpty()) {
            return s -> true;
        }
        return s -> {
            for (Predicate p : predicateList) {
                if (p.test(s)) continue;
                return false;
            }
            return true;
        };
    }

    static {
        PREFIXES.put(">=", target -> source -> source.compareTo((SemanticVersion)target) >= 0);
        PREFIXES.put("<=", target -> source -> source.compareTo((SemanticVersion)target) <= 0);
        PREFIXES.put(">", target -> source -> source.compareTo((SemanticVersion)target) > 0);
        PREFIXES.put("<", target -> source -> source.compareTo((SemanticVersion)target) < 0);
        PREFIXES.put("=", target -> source -> source.compareTo((SemanticVersion)target) == 0);
        PREFIXES.put("~", target -> source -> source.compareTo((SemanticVersion)target) >= 0 && source.getVersionComponent(0) == target.getVersionComponent(0) && source.getVersionComponent(1) == target.getVersionComponent(1));
        PREFIXES.put("^", target -> source -> source.compareTo((SemanticVersion)target) >= 0 && source.getVersionComponent(0) == target.getVersionComponent(0));
    }
}

