/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.api.util;

import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1405;
import net.minecraft.class_1406;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1410;
import net.minecraft.class_1411;
import net.minecraft.class_1412;
import net.minecraft.class_1416;
import net.minecraft.class_1418;
import net.minecraft.class_1419;

/**
 * NBT type ID constants. Useful for filtering by value type in a few cases.
 *
 * <p>For the current list of types, check with {@link class_1419#field_5927}.
 *
 * @see class_1405#method_5014(String, int)
 */
public final class NbtType {
	/**
	 * @see class_1407
	 */
	public static final int END = 0;
	/**
	 * @see class_1404
	 */
	public static final int BYTE = 1;
	/**
	 * @see class_1416
	 */
	public static final int SHORT = 2;
	/**
	 * @see class_1410
	 */
	public static final int INT = 3;
	/**
	 * @see class_1412
	 */
	public static final int LONG = 4;
	/**
	 * @see class_1408
	 */
	public static final int FLOAT = 5;
	/**
	 * @see class_1406
	 */
	public static final int DOUBLE = 6;
	/**
	 * @see class_1403
	 */
	public static final int BYTE_ARRAY = 7;
	/**
	 * @see class_1418
	 */
	public static final int STRING = 8;
	/**
	 * @see class_1411
	 */
	public static final int LIST = 9;
	/**
	 * @see class_1405
	 */
	public static final int COMPOUND = 10;
	/**
	 * @see class_1409
	 */
	public static final int INT_ARRAY = 11;
	/**
	 * Any numeric value: byte, short, int, long, float, double.
	 *
	 * @see class_1405#method_5014(String, int)
	 */
	public static final int NUMBER = 99;

	private NbtType() {
	}
}
