/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.api.client.event.lifecycle.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

import net.legacyfabric.fabric.api.event.Event;
import net.legacyfabric.fabric.api.event.EventFactory;
import net.minecraft.class_1705;
import net.minecraft.class_399;
import net.minecraft.class_907;

@Environment(EnvType.CLIENT)
public final class ClientChunkEvents {
	private ClientChunkEvents() {
	}

	/**
	 * Called when a chunk is loaded into a ClientWorld.
	 *
	 * <p>When this event is called, the chunk is already in the world.
	 */
	public static final Event<Load> CHUNK_LOAD = EventFactory.createArrayBacked(Load.class, callbacks -> (clientWorld, chunk) -> {
		if (EventFactory.isProfilingEnabled()) {
			class_1705 profiler = clientWorld.field_250;
			profiler.method_6668("fabricClientChunkLoad");

			for (Load callback : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(callback));
				callback.onChunkLoad(clientWorld, chunk);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (Load callback : callbacks) {
				callback.onChunkLoad(clientWorld, chunk);
			}
		}
	});

	/**
	 * Called when a chunk is about to be unloaded from a ClientWorld.
	 *
	 * <p>When this event is called, the chunk is still present in the world.
	 */
	public static final Event<Unload> CHUNK_UNLOAD = EventFactory.createArrayBacked(Unload.class, callbacks -> (clientWorld, chunk) -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = clientWorld.field_250;
			profiler.method_6668("fabricClientChunkUnload");

			for (Unload callback : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(callback));
				callback.onChunkUnload(clientWorld, chunk);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (Unload callback : callbacks) {
				callback.onChunkUnload(clientWorld, chunk);
			}
		}
	});

	@FunctionalInterface
	public interface Load {
		void onChunkLoad(class_907 world, class_399 chunk);
	}

	@FunctionalInterface
	public interface Unload {
		void onChunkUnload(class_907 world, class_399 chunk);
	}
}
