/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.api.client.event.lifecycle.v1;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

import net.legacyfabric.fabric.api.event.Event;
import net.legacyfabric.fabric.api.event.EventFactory;
import net.minecraft.class_1705;
import net.minecraft.class_669;
import net.minecraft.class_907;

@Environment(EnvType.CLIENT)
public final class ClientTickEvents {
	public ClientTickEvents() {
	}

	/**
	 * Called at the start of the client tick.
	 */
	public static final Event<StartTick> START_CLIENT_TICK = EventFactory.createArrayBacked(StartTick.class, callbacks -> client -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = client.field_2508;
			profiler.method_6668("fabricStartClientTick");

			for (StartTick event : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(event));
				event.onStartTick(client);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (StartTick event : callbacks) {
				event.onStartTick(client);
			}
		}
	});

	/**
	 * Called at the end of the client tick.
	 */
	public static final Event<EndTick> END_CLIENT_TICK = EventFactory.createArrayBacked(EndTick.class, callbacks -> client -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = client.field_2508;
			profiler.method_6668("fabricEndClientTick");

			for (EndTick event : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(event));
				event.onEndTick(client);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (EndTick event : callbacks) {
				event.onEndTick(client);
			}
		}
	});

	/**
	 * Called at the start of a ClientWorld's tick.
	 */
	public static final Event<StartWorldTick> START_WORLD_TICK = EventFactory.createArrayBacked(StartWorldTick.class, callbacks -> world -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = world.field_250;
			profiler.method_6668("fabricStartClientWorldTick");

			for (StartWorldTick callback : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(callback));
				callback.onStartTick(world);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (StartWorldTick callback : callbacks) {
				callback.onStartTick(world);
			}
		}
	});

	/**
	 * Called at the end of a ClientWorld's tick.
	 *
	 * <p>End of world tick may be used to start async computations for the next tick.
	 */
	public static final Event<EndWorldTick> END_WORLD_TICK = EventFactory.createArrayBacked(EndWorldTick.class, callbacks -> world -> {
		if (EventFactory.isProfilingEnabled()) {
			final class_1705 profiler = world.field_250;
			profiler.method_6668("fabricEndClientWorldTick");

			for (EndWorldTick callback : callbacks) {
				profiler.method_6668(EventFactory.getHandlerName(callback));
				callback.onEndTick(world);
				profiler.method_6669();
			}

			profiler.method_6669();
		} else {
			for (EndWorldTick callback : callbacks) {
				callback.onEndTick(world);
			}
		}
	});

	@FunctionalInterface
	public interface StartTick {
		void onStartTick(class_669 client);
	}

	@FunctionalInterface
	public interface EndTick {
		void onEndTick(class_669 client);
	}

	@FunctionalInterface
	public interface StartWorldTick {
		void onStartTick(class_907 world);
	}

	@FunctionalInterface
	public interface EndWorldTick {
		void onEndTick(class_907 world);
	}
}
