/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.impl.networking.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

import net.legacyfabric.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.legacyfabric.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.legacyfabric.fabric.impl.networking.GlobalReceiverRegistry;
import net.legacyfabric.fabric.mixin.networking.client.ConnectScreenAccessor;
import net.legacyfabric.fabric.mixin.networking.client.MinecraftClientAccessor;
import net.minecraft.class_1432;
import net.minecraft.class_1435;
import net.minecraft.class_1457;
import net.minecraft.class_1560;
import net.minecraft.class_669;
import net.minecraft.class_727;
import net.minecraft.class_903;

@Environment(EnvType.CLIENT)
public final class ClientNetworkingImpl {
	public static final GlobalReceiverRegistry<ClientPlayNetworking.PlayChannelHandler> PLAY = new GlobalReceiverRegistry<>();
	private static ClientPlayNetworkAddon currentPlayAddon;

	public static ClientPlayNetworkAddon getAddon(class_903 handler) {
		return ((ClientPlayNetworkHandlerExtensions) handler).getAddon();
	}

	public static class_1457<?> createPlayC2SPacket(String channelName, class_1435 buf) {
		return new class_1560(channelName, buf);
	}

	/**
	 * Due to the way logging into a integrated or remote dedicated server will differ, we need to obtain the login client connection differently.
	 */
	public static class_1432 getLoginConnection() {
		final class_1432 connection = ((MinecraftClientAccessor) class_669.method_2221()).getClientConnection();

		// Check if we are connecting to an integrated server. This will set the field on MinecraftClient
		if (connection != null) {
			return connection;
		} else {
			// We are probably connecting to a remote server.
			// Check if the ConnectScreen is the currentScreen to determine that:
			if (class_669.method_2221().field_2590 instanceof class_727) {
				return ((ConnectScreenAccessor) class_669.method_2221().field_2590).getConnection();
			}
		}

		// We are not connected to a server at all.
		return null;
	}

	public static ClientPlayNetworkAddon getClientPlayAddon() {
		// Since Minecraft can be a bit weird, we need to check for the play addon in a few ways:
		// If the client's player is set this will work
		if (class_669.method_2221().method_2316() != null) {
			currentPlayAddon = null; // Shouldn't need this anymore
			return ClientNetworkingImpl.getAddon(class_669.method_2221().method_2316());
		}

		// We haven't hit the end of onGameJoin yet, use our backing field here to access the network handler
		if (currentPlayAddon != null) {
			return currentPlayAddon;
		}

		// We are not in play stage
		return null;
	}

	public static void setClientPlayAddon(ClientPlayNetworkAddon addon) {
		currentPlayAddon = addon;
	}

	public static void clientInit() {
		// Reference cleanup for the locally stored addon if we are disconnected
		ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
			currentPlayAddon = null;
		});
	}
}
