/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.mixin.networking;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.minecraft.class_1432;
import net.minecraft.class_1444;
import net.minecraft.class_1457;
import net.minecraft.class_1489;
import net.minecraft.class_1560;
import net.minecraft.class_1643;
import net.minecraft.server.MinecraftServer;
import net.legacyfabric.fabric.impl.networking.DisconnectPacketSource;
import net.legacyfabric.fabric.impl.networking.server.ServerPlayNetworkAddon;
import net.legacyfabric.fabric.impl.networking.server.ServerPlayNetworkHandlerExtensions;

// We want to apply a bit earlier than other mods which may not use us in order to prevent refCount issues
@Mixin(value = class_1643.class, priority = 999)
abstract class ServerPlayNetworkHandlerMixin implements ServerPlayNetworkHandlerExtensions, DisconnectPacketSource {
	@Shadow
	@Final
	private MinecraftServer server;
	@Shadow
	@Final
	public class_1432 connection;

	@Unique
	private ServerPlayNetworkAddon addon;

	@Inject(method = "<init>", at = @At("RETURN"))
	private void initAddon(CallbackInfo ci) {
		this.addon = new ServerPlayNetworkAddon((class_1643) (Object) this, this.server);
		// A bit of a hack but it allows the field above to be set in case someone registers handlers during INIT event which refers to said field
		this.addon.lateInit();
	}

	@Inject(method = "onCustomPayload", at = @At("HEAD"), cancellable = true)
	private void handleCustomPayloadReceivedAsync(class_1560 packet, CallbackInfo ci) {
		if (this.addon.handle(packet)) {
			// Do not cancel minecraft's packets
			if (!packet.method_5761().startsWith("MC")) {
				ci.cancel();
			}
		}
	}

	@Inject(method = "onDisconnected", at = @At("HEAD"))
	private void handleDisconnection(class_1444 reason, CallbackInfo ci) {
		this.addon.invokeDisconnectEvent();
	}

	@Override
	public ServerPlayNetworkAddon getAddon() {
		return this.addon;
	}

	@Override
	public class_1457<?> createDisconnectPacket(class_1444 message) {
		return new class_1489(message);
	}
}
