/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.api.client.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.legacyfabric.fabric.api.networking.v1.PacketSender;
import net.legacyfabric.fabric.impl.networking.client.ClientNetworkingImpl;
import net.legacyfabric.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.minecraft.class_1435;
import net.minecraft.class_1457;
import net.minecraft.class_1605;
import net.minecraft.class_669;
import net.minecraft.class_903;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworking {
    public static boolean registerGlobalReceiver(String channelName, PlayChannelHandler channelHandler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    public static boolean registerGlobalReceiver(class_1605 channelId, PlayChannelHandler channelHandler) {
        return ClientPlayNetworking.registerGlobalReceiver(channelId.toString(), channelHandler);
    }

    public static PlayChannelHandler unregisterGlobalReceiver(String channelName) {
        return ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    public static PlayChannelHandler unregisterGlobalReceiver(class_1605 channelId) {
        return ClientPlayNetworking.unregisterGlobalReceiver(channelId.toString());
    }

    public static Set<String> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(String channelName, PlayChannelHandler channelHandler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, channelHandler);
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    public static boolean registerReceiver(class_1605 channelId, PlayChannelHandler channelHandler) {
        return ClientPlayNetworking.registerReceiver(channelId.toString(), channelHandler);
    }

    public static PlayChannelHandler unregisterReceiver(String channelName) throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return (PlayChannelHandler)addon.unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    public static PlayChannelHandler unregisterReceiver(class_1605 channelId) throws IllegalStateException {
        return ClientPlayNetworking.unregisterReceiver(channelId.toString());
    }

    public static Set<String> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<String> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(String channelName) throws IllegalArgumentException {
        if (class_669.method_2221().method_2316() != null) {
            return ClientNetworkingImpl.getAddon(class_669.method_2221().method_2316()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static boolean canSend(class_1605 channelId) throws IllegalArgumentException {
        return ClientPlayNetworking.canSend(channelId.toString());
    }

    public static class_1457<?> createC2SPacket(String channelName, class_1435 buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static class_1457<?> createC2SPacket(class_1605 channelId, class_1435 buf) {
        return ClientPlayNetworking.createC2SPacket(channelId.toString(), buf);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (class_669.method_2221().method_2316() != null) {
            return ClientNetworkingImpl.getAddon(class_669.method_2221().method_2316());
        }
        throw new IllegalStateException("Cannot get packet sender when not in game!");
    }

    public static void send(String channelName, class_1435 buf) throws IllegalStateException {
        if (class_669.method_2221().method_2316() != null) {
            class_669.method_2221().method_2316().method_3113(ClientPlayNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static void send(class_1605 channelId, class_1435 buf) throws IllegalStateException {
        if (class_669.method_2221().method_2316() != null) {
            class_669.method_2221().method_2316().method_3113(ClientPlayNetworking.createC2SPacket(channelId, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface PlayChannelHandler {
        public void receive(class_669 var1, class_903 var2, class_1435 var3, PacketSender var4);
    }
}

