/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.impl.networking;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.legacyfabric.fabric.api.networking.v1.PacketByteBufs;
import net.legacyfabric.fabric.api.networking.v1.PacketSender;
import net.legacyfabric.fabric.impl.networking.AbstractNetworkAddon;
import net.legacyfabric.fabric.impl.networking.ChannelInfoHolder;
import net.legacyfabric.fabric.impl.networking.GlobalReceiverRegistry;
import net.minecraft.class_1432;
import net.minecraft.class_1435;
import net.minecraft.class_1457;

public abstract class AbstractChanneledNetworkAddon<H>
extends AbstractNetworkAddon<H>
implements PacketSender {
    protected final class_1432 connection;
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Set<String> sendableChannels;
    protected final Set<String> sendableChannelsView;

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, class_1432 connection, String description) {
        this(receiver, connection, new HashSet<String>(), description);
    }

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, class_1432 connection, Set<String> sendableChannels, String description) {
        super(receiver, description);
        this.connection = connection;
        this.receiver = receiver;
        this.sendableChannels = sendableChannels;
        this.sendableChannelsView = Collections.unmodifiableSet(sendableChannels);
    }

    public abstract void lateInit();

    protected void registerPendingChannels(ChannelInfoHolder holder) {
        Collection<String> pending = holder.getPendingChannelsNames();
        if (!pending.isEmpty()) {
            this.register(new ArrayList<String>(pending));
            pending.clear();
        }
    }

    protected boolean handle(String channelName, class_1435 originalBuf) {
        this.logger.debug("Handling inbound packet from channel with name \"{}\"", new Object[]{channelName});
        if ("REGISTER".equals(channelName)) {
            this.receiveRegistration(true, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        if ("UNREGISTER".equals(channelName)) {
            this.receiveRegistration(false, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        Object handler = this.getHandler(channelName);
        if (handler == null) {
            return false;
        }
        class_1435 buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        try {
            this.receive(handler, buf);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", new Object[]{channelName, ex});
            throw ex;
        }
        return true;
    }

    protected abstract void receive(H var1, class_1435 var2);

    protected void sendInitialChannelRegistrationPacket() {
        class_1435 buf = this.createRegistrationPacket(this.getReceivableChannels());
        if (buf != null) {
            this.sendPacket("REGISTER", buf);
        }
    }

    protected class_1435 createRegistrationPacket(Collection<String> channels) {
        if (channels.isEmpty()) {
            return null;
        }
        class_1435 buf = PacketByteBufs.create();
        boolean first = true;
        for (String channel : channels) {
            if (first) {
                first = false;
            } else {
                buf.writeByte(0);
            }
            buf.writeBytes(channel.getBytes(StandardCharsets.US_ASCII));
        }
        return buf;
    }

    protected void receiveRegistration(boolean register, class_1435 buf) {
        ArrayList<String> ids = new ArrayList<String>();
        StringBuilder active = new StringBuilder();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 0) {
                active.append((char)b);
                continue;
            }
            this.addId(ids, active);
            active = new StringBuilder();
        }
        this.addId(ids, active);
        this.schedule(register ? () -> this.register(ids) : () -> this.unregister(ids));
    }

    void register(List<String> ids) {
        this.sendableChannels.addAll(ids);
        this.invokeRegisterEvent(ids);
    }

    void unregister(List<String> ids) {
        this.sendableChannels.removeAll(ids);
        this.invokeUnregisterEvent(ids);
    }

    @Override
    public void sendPacket(class_1457<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_5098(packet);
    }

    @Override
    public void sendPacket(class_1457<?> packet, GenericFutureListener<? extends Future<? super Void>> callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.method_5099(packet, callback, new GenericFutureListener[0]);
    }

    protected abstract void schedule(Runnable var1);

    protected abstract void invokeRegisterEvent(List<String> var1);

    protected abstract void invokeUnregisterEvent(List<String> var1);

    private void addId(List<String> ids, StringBuilder sb) {
        String literal = sb.toString();
        ids.add(literal);
    }

    public Set<String> getSendableChannels() {
        return this.sendableChannelsView;
    }
}

