/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.impl.networking;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.legacyfabric.fabric.impl.networking.GlobalReceiverRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractNetworkAddon<H> {
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Logger logger;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, H> handlers = new HashMap<String, H>();

    protected AbstractNetworkAddon(GlobalReceiverRegistry<H> receiver, String description) {
        this.receiver = receiver;
        this.logger = LogManager.getLogger((String)description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H getHandler(String channel) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            H h = this.handlers.get(channel);
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerChannel(String channelName, H handler) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(handler, "Packet handler cannot be null");
        if (this.isReservedChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            boolean replaced;
            boolean bl = replaced = this.handlers.putIfAbsent(channelName, handler) == null;
            if (replaced) {
                this.handleRegistration(channelName);
            }
            boolean bl2 = replaced;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H unregisterChannel(String channelName) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        if (this.isReservedChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            H removed = this.handlers.remove(channelName);
            if (removed != null) {
                this.handleUnregistration(channelName);
            }
            H h = removed;
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<String> getReceivableChannels() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.handlers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void handleRegistration(String var1);

    protected abstract void handleUnregistration(String var1);

    public abstract void invokeDisconnectEvent();

    protected abstract boolean isReservedChannel(String var1);
}

