/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.api.networking.v1;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.legacyfabric.fabric.mixin.networking.EntityTrackerAccessor;
import net.legacyfabric.fabric.mixin.networking.EntityTrackerEntryAccessor;
import net.minecraft.class_1400;
import net.minecraft.class_1635;
import net.minecraft.class_1637;
import net.minecraft.class_1639;
import net.minecraft.class_1745;
import net.minecraft.class_649;
import net.minecraft.server.MinecraftServer;

public final class PlayerLookup {
    public static Collection<class_1637> all(MinecraftServer server) {
        Objects.requireNonNull(server, "The server cannot be null");
        if (server.method_6480() != null) {
            return Collections.unmodifiableCollection(server.method_6480().method_6248());
        }
        return Collections.emptyList();
    }

    public static Collection<class_1637> world(class_1635 world) {
        Objects.requireNonNull(world, "The world cannot be null");
        return Collections.unmodifiableCollection(world.method_6055().method_6480().method_6248());
    }

    public static Collection<class_1637> tracking(class_1745 entity) {
        Objects.requireNonNull(entity, "Entity cannot be null");
        if (entity.field_7394 instanceof class_1635) {
            return Optional.of(entity.field_7394).map(class_1635.class::cast).map(class_1635::method_6056).map(EntityTrackerAccessor.class::cast).map(EntityTrackerAccessor::getTrackedEntityIds).map(c -> (class_1639)c.method_6582(entity.method_6895())).map(EntityTrackerEntryAccessor.class::cast).map(EntityTrackerEntryAccessor::getPlayers).map(Collections::unmodifiableSet).orElseGet(Collections::emptySet);
        }
        throw new IllegalArgumentException("Only supported on server worlds!");
    }

    public static Collection<class_1637> around(class_1635 world, class_649 pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.method_7023(pos.field_2422, pos.field_2423, pos.field_2424) <= radiusSq).collect(Collectors.toList());
    }

    public static Collection<class_1637> around(class_1635 world, class_1400 pos, double radius) {
        double radiusSq = radius * radius;
        return PlayerLookup.world(world).stream().filter(p -> p.method_7023((double)pos.method_4978(), (double)pos.method_4979(), (double)pos.method_4980()) <= radiusSq).collect(Collectors.toList());
    }

    private PlayerLookup() {
    }
}

