/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.api.networking.v1;

import java.util.Objects;
import java.util.Set;
import net.legacyfabric.fabric.api.networking.v1.PacketSender;
import net.legacyfabric.fabric.impl.networking.server.ServerNetworkingImpl;
import net.legacyfabric.fabric.impl.networking.server.ServerPlayNetworkHandlerExtensions;
import net.minecraft.class_1435;
import net.minecraft.class_1457;
import net.minecraft.class_1605;
import net.minecraft.class_1637;
import net.minecraft.class_1643;
import net.minecraft.server.MinecraftServer;

public final class ServerPlayNetworking {
    public static boolean registerGlobalReceiver(String channelName, PlayChannelHandler channelHandler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    public static boolean registerGlobalReceiver(class_1605 channelId, PlayChannelHandler channelHandler) {
        return ServerPlayNetworking.registerGlobalReceiver(channelId.toString(), channelHandler);
    }

    public static PlayChannelHandler unregisterGlobalReceiver(String channelName) {
        return ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    public static PlayChannelHandler unregisterGlobalReceiver(class_1605 channelId) {
        return ServerPlayNetworking.unregisterGlobalReceiver(channelId.toString());
    }

    public static Set<String> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(class_1643 networkHandler, String channelName, PlayChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ((ServerPlayNetworkHandlerExtensions)networkHandler).getAddon().registerChannel(channelName, channelHandler);
    }

    public static boolean registerReceiver(class_1643 networkHandler, class_1605 channelId, PlayChannelHandler channelHandler) {
        return ServerPlayNetworking.registerReceiver(networkHandler, channelId.toString(), channelHandler);
    }

    public static PlayChannelHandler unregisterReceiver(class_1643 networkHandler, String channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (PlayChannelHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    public static PlayChannelHandler unregisterReceiver(class_1643 networkHandler, class_1605 channelId) {
        return ServerPlayNetworking.unregisterReceiver(networkHandler, channelId.toString());
    }

    public static Set<String> getReceived(class_1637 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.field_6639);
    }

    public static Set<String> getReceived(class_1643 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<String> getSendable(class_1637 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.field_6639);
    }

    public static Set<String> getSendable(class_1643 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(class_1637 player, String channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.field_6639, channelName);
    }

    public static boolean canSend(class_1643 handler, String channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static class_1457<?> createS2CPacket(String channelName, class_1435 buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static class_1457<?> createS2CPacket(class_1605 channelId, class_1435 buf) {
        return ServerPlayNetworking.createS2CPacket(channelId.toString(), buf);
    }

    public static PacketSender getSender(class_1637 player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.field_6639);
    }

    public static PacketSender getSender(class_1643 handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(class_1637 player, String channelName, class_1435 buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.field_6639.method_6127(ServerPlayNetworking.createS2CPacket(channelName, buf));
    }

    public static void send(class_1637 player, class_1605 channelId, class_1435 buf) {
        ServerPlayNetworking.send(player, channelId.toString(), buf);
    }

    public static MinecraftServer getServer(class_1643 handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return handler.field_6719.field_6645;
    }

    private ServerPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(MinecraftServer var1, class_1637 var2, class_1643 var3, class_1435 var4, PacketSender var5);
    }
}

