/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.impl.networking;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.legacyfabric.fabric.impl.networking.AbstractNetworkAddon;
import net.legacyfabric.fabric.impl.networking.NetworkingImpl;

public final class GlobalReceiverRegistry<H> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, H> handlers;
    private final Set<AbstractNetworkAddon<H>> trackedAddons = new HashSet<AbstractNetworkAddon<H>>();

    public GlobalReceiverRegistry() {
        this(new HashMap());
    }

    public GlobalReceiverRegistry(Map<String, H> map) {
        this.handlers = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H getHandler(String channelName) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            H h = this.handlers.get(channelName);
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerGlobalReceiver(String channelName, H handler) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(handler, "Channel handler cannot be null");
        if (NetworkingImpl.isReservedPlayChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            boolean replaced;
            boolean bl = replaced = this.handlers.putIfAbsent(channelName, handler) == null;
            if (!replaced) {
                this.handleRegistration(channelName, handler);
            }
            boolean bl2 = replaced;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H unregisterGlobalReceiver(String channelName) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        if (NetworkingImpl.isReservedPlayChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot unregister packet handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            H removed = this.handlers.remove(channelName);
            if (removed != null) {
                this.handleUnregistration(channelName);
            }
            H h = removed;
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<String, H> getHandlers() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            HashMap<String, H> hashMap = new HashMap<String, H>(this.handlers);
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<String> getChannels() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.handlers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public void startSession(AbstractNetworkAddon<H> addon) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.trackedAddons.add(addon);
        }
        finally {
            lock.unlock();
        }
    }

    public void endSession(AbstractNetworkAddon<H> addon) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.trackedAddons.remove(addon);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegistration(String channelName, H handler) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            for (AbstractNetworkAddon<H> addon : this.trackedAddons) {
                addon.registerChannel(channelName, handler);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnregistration(String channelName) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            for (AbstractNetworkAddon<H> addon : this.trackedAddons) {
                addon.unregisterChannel(channelName);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

