/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.impl.networking.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.legacyfabric.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.legacyfabric.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.legacyfabric.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.legacyfabric.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.legacyfabric.fabric.impl.networking.ChannelInfoHolder;
import net.legacyfabric.fabric.impl.networking.NetworkingImpl;
import net.legacyfabric.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.class_1435;
import net.minecraft.class_1457;
import net.minecraft.class_1488;
import net.minecraft.class_669;
import net.minecraft.class_903;

@Environment(value=EnvType.CLIENT)
public final class ClientPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ClientPlayNetworking.PlayChannelHandler> {
    private final class_903 handler;
    private final class_669 client;
    private boolean sentInitialRegisterPacket;

    public ClientPlayNetworkAddon(class_903 handler, class_669 client) {
        super(ClientNetworkingImpl.PLAY, handler.method_3110(), "ClientPlayNetworkAddon for " + handler.method_3119().getName());
        this.handler = handler;
        this.client = client;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ClientPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ((ClientPlayConnectionEvents.Init)ClientPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.client);
    }

    public void onServerReady() {
        ((ClientPlayConnectionEvents.Join)ClientPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.client);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(class_1488 packet) {
        if (this.client.method_6734()) {
            return false;
        }
        class_1435 buf = packet.method_5446();
        try {
            boolean bl = this.handle(packet.method_5444(), buf);
            return bl;
        }
        finally {
            buf.release();
        }
    }

    @Override
    protected void receive(ClientPlayNetworking.PlayChannelHandler handler, class_1435 buf) {
        handler.receive(this.client, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        class_669.method_2221().method_6733(task);
    }

    @Override
    public class_1457<?> createPacket(String channelName, class_1435 buf) {
        return ClientPlayNetworking.createC2SPacket(channelName, buf);
    }

    @Override
    protected void invokeRegisterEvent(List<String> ids) {
        ((C2SPlayChannelEvents.Register)C2SPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<String> ids) {
        ((C2SPlayChannelEvents.Unregister)C2SPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.client, ids);
    }

    @Override
    protected void handleRegistration(String channelName) {
        class_1435 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket("REGISTER", buf);
        }
    }

    @Override
    protected void handleUnregistration(String channelName) {
        class_1435 buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket("UNREGISTER", buf);
        }
    }

    @Override
    public void invokeDisconnectEvent() {
        ((ClientPlayConnectionEvents.Disconnect)ClientPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.client);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(String channelName) {
        return NetworkingImpl.isReservedPlayChannel(channelName);
    }
}

