/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.api.client.rendering.v1;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1135;
import net.minecraft.class_1136;
import net.minecraft.class_1150;
import net.minecraft.class_1232;
import net.minecraft.class_1258;
import net.minecraft.class_1745;

public class EntityRendererRegistry {
    public static final EntityRendererRegistry INSTANCE = new EntityRendererRegistry();
    private final Map<class_1135, Context> renderManagerMap = new WeakHashMap<class_1135, Context>();
    private final Map<Class<? extends class_1745>, Factory> renderSupplierMap = new HashMap<Class<? extends class_1745>, Factory>();

    private EntityRendererRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(class_1135 manager, class_1232 textureManager, class_1258 resourceManager, class_1150 itemRenderer, Map<Class<? extends class_1745>, class_1136<?>> renderers) {
        Map<Class<? extends class_1745>, Factory> map = this.renderSupplierMap;
        synchronized (map) {
            if (this.renderManagerMap.containsKey(manager)) {
                return;
            }
            Context context = new Context(textureManager, resourceManager, itemRenderer, renderers);
            this.renderManagerMap.put(manager, context);
            for (Class<? extends class_1745> c : this.renderSupplierMap.keySet()) {
                renderers.put(c, this.renderSupplierMap.get(c).create(manager, context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<? extends class_1745> entityClass, Factory factory) {
        Map<Class<? extends class_1745>, Factory> map = this.renderSupplierMap;
        synchronized (map) {
            this.renderSupplierMap.put(entityClass, factory);
            for (class_1135 manager : this.renderManagerMap.keySet()) {
                this.renderManagerMap.get(manager).rendererMap.put(entityClass, factory.create(manager, this.renderManagerMap.get(manager)));
            }
        }
    }

    public static final class Context {
        private final class_1232 textureManager;
        private final class_1258 resourceManager;
        private final class_1150 itemRenderer;
        private final Map<Class<? extends class_1745>, class_1136<?>> rendererMap;

        private Context(class_1232 textureManager, class_1258 resourceManager, class_1150 itemRenderer, Map<Class<? extends class_1745>, class_1136<?>> rendererMap) {
            this.textureManager = textureManager;
            this.resourceManager = resourceManager;
            this.itemRenderer = itemRenderer;
            this.rendererMap = rendererMap;
        }

        public class_1232 getTextureManager() {
            return this.textureManager;
        }

        public class_1258 getResourceManager() {
            return this.resourceManager;
        }

        public class_1150 getItemRenderer() {
            return this.itemRenderer;
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public class_1136<? extends class_1745> create(class_1135 var1, Context var2);
    }
}

