/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.api.client.rendering.v1;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1135;
import net.minecraft.class_1136;
import net.minecraft.class_1150;
import net.minecraft.class_1232;
import net.minecraft.class_1258;
import net.minecraft.class_1745;

/**
 * Helper class for registering EntityRenderers.
 */
public class EntityRendererRegistry {
	@FunctionalInterface
	public interface Factory {
		class_1136<? extends class_1745> create(class_1135 manager, Context context);
	}

	public static final class Context {
		private final class_1232 textureManager;
		private final class_1258 resourceManager;
		private final class_1150 itemRenderer;
		private final Map<Class<? extends class_1745>, class_1136<?>> rendererMap;

		private Context(class_1232 textureManager, class_1258 resourceManager, class_1150 itemRenderer, Map<Class<? extends class_1745>, class_1136<?>> rendererMap) {
			this.textureManager = textureManager;
			this.resourceManager = resourceManager;
			this.itemRenderer = itemRenderer;
			this.rendererMap = rendererMap;
		}

		public class_1232 getTextureManager() {
			return textureManager;
		}

		public class_1258 getResourceManager() {
			return resourceManager;
		}

		public class_1150 getItemRenderer() {
			return itemRenderer;
		}
	}

	public static final EntityRendererRegistry INSTANCE = new EntityRendererRegistry();
	private final Map<class_1135, Context> renderManagerMap = new WeakHashMap<>();
	private final Map<Class<? extends class_1745>, Factory> renderSupplierMap = new HashMap<>();

	private EntityRendererRegistry() {
	}

	public void initialize(class_1135 manager, class_1232 textureManager, class_1258 resourceManager, class_1150 itemRenderer, Map<Class<? extends class_1745>, class_1136<?>> renderers) {
		synchronized (renderSupplierMap) {
			if (renderManagerMap.containsKey(manager)) {
				return;
			}

			Context context = new Context(textureManager, resourceManager, itemRenderer, renderers);
			renderManagerMap.put(manager, context);

			for (Class<? extends class_1745> c : renderSupplierMap.keySet()) {
				renderers.put(c, renderSupplierMap.get(c).create(manager, context));
			}
		}
	}

	public void register(Class<? extends class_1745> entityClass, Factory factory) {
		synchronized (renderSupplierMap) {
			// TODO: warn on duplicate
			renderSupplierMap.put(entityClass, factory);

			for (class_1135 manager : renderManagerMap.keySet()) {
				renderManagerMap.get(manager).rendererMap.put(entityClass, factory.create(manager, renderManagerMap.get(manager)));
			}
		}
	}
}
