/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.mixin.client.rendering;

import java.util.Map;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.legacyfabric.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.legacyfabric.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.legacyfabric.fabric.impl.client.rendering.RegistrationHelperImpl;
import net.minecraft.class_1135;
import net.minecraft.class_1136;
import net.minecraft.class_1150;
import net.minecraft.class_1154;
import net.minecraft.class_1208;
import net.minecraft.class_1232;
import net.minecraft.class_1745;
import net.minecraft.class_1752;
import net.minecraft.class_669;
import net.minecraft.class_993;

@Mixin(class_1135.class)
public abstract class EntityRenderDispatcherMixin {
	@Shadow
	@Final
	private Map<Class<? extends class_1745>, class_1136<?>> renderers;

	@Shadow
	@Final
	private Map<String, class_1208> modelRenderers;

	@SuppressWarnings({"unchecked", "rawtypes"})
	@Inject(method = "<init>", at = @At("TAIL"))
	private void afterRegisterRenderers(class_1232 textureManager, class_1150 itemRenderer, CallbackInfo ci) {
		final class_1135 me = (class_1135) (Object) this;
		EntityRendererRegistry.INSTANCE.initialize(me, textureManager, class_669.method_2221().method_2237(), itemRenderer, renderers);

		// Dispatch events to register feature renderers.
		for (Map.Entry<Class<? extends class_1745>, class_1136<?>> entry : this.renderers.entrySet()) {
			if (entry.getValue() instanceof class_1154) { // Must be living for features
				LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor) entry.getValue();

				LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker().registerRenderers((Class<? extends class_1752>) entry.getKey(), (class_1154) entry.getValue(), new RegistrationHelperImpl(accessor::callAddFeature));
			}
		}

		// Players are a fun case, we need to do these separately and per model type
		for (Map.Entry<String, class_1208> entry : this.modelRenderers.entrySet()) {
			LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor) entry.getValue();

			LivingEntityFeatureRendererRegistrationCallback.EVENT.invoker().registerRenderers(class_993.class, entry.getValue(), new RegistrationHelperImpl(accessor::callAddFeature));
		}
	}
}
