/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.impl.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import net.legacyfabric.fabric.impl.resource.loader.DeferredNioExecutionHandler;

class DeferredInputStream
extends InputStream {
    private final InputStream stream;

    public static InputStream deferIfNeeded(Callable<InputStream> streamSupplier) throws IOException {
        if (DeferredNioExecutionHandler.shouldDefer()) {
            return new DeferredInputStream(streamSupplier);
        }
        return DeferredNioExecutionHandler.submit(streamSupplier, false);
    }

    DeferredInputStream(Callable<InputStream> streamSupplier) throws IOException {
        this.stream = DeferredNioExecutionHandler.submit(streamSupplier);
        if (this.stream == null) {
            throw new IOException("Something happened while trying to create an InputStream!");
        }
    }

    DeferredInputStream(InputStream stream) throws IOException {
        this.stream = stream;
        if (this.stream == null) {
            throw new IOException("Something happened while trying to create an InputStream!");
        }
    }

    @Override
    public int available() throws IOException {
        return DeferredNioExecutionHandler.submit(this.stream::available);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public void mark(int readLimit) {
        this.stream.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        DeferredNioExecutionHandler.submit(() -> {
            this.stream.reset();
            return null;
        });
    }

    @Override
    public long skip(long n) throws IOException {
        return DeferredNioExecutionHandler.submit(() -> this.stream.skip(n));
    }

    @Override
    public int read() throws IOException {
        return DeferredNioExecutionHandler.submit(this.stream::read);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return DeferredNioExecutionHandler.submit(() -> this.stream.read(b));
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return DeferredNioExecutionHandler.submit(() -> this.stream.read(b, offset, length));
    }

    @Override
    public void close() throws IOException {
        DeferredNioExecutionHandler.submit(() -> {
            this.stream.close();
            return null;
        });
    }
}

