/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.api.resource;

import net.minecraft.class_1605;

/**
 * This class contains default keys for various Minecraft resource reload listeners.
 *
 * @see IdentifiableResourceReloadListener
 */
public final class ResourceReloadListenerKeys {
	// client
	public static final class_1605 SOUNDS = new class_1605("minecraft:sounds");
	public static final class_1605 FONTS = new class_1605("minecraft:fonts");
	public static final class_1605 MODELS = new class_1605("minecraft:models");
	public static final class_1605 LANGUAGES = new class_1605("minecraft:languages");
	public static final class_1605 TEXTURES = new class_1605("minecraft:textures");

	private ResourceReloadListenerKeys() {
	}
}
