/*
 * Copyright (c) 2020 - 2021 Legacy Fabric
 * Copyright (c) 2016 - 2021 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.legacyfabric.fabric.mixin.resource.loader.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

import org.spongepowered.asm.mixin.Mixin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;

import net.legacyfabric.fabric.api.resource.IdentifiableResourceReloadListener;
import net.legacyfabric.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1012;
import net.minecraft.class_1036;
import net.minecraft.class_1048;
import net.minecraft.class_1150;
import net.minecraft.class_1232;
import net.minecraft.class_1254;
import net.minecraft.class_1255;
import net.minecraft.class_1270;
import net.minecraft.class_1292;
import net.minecraft.class_1328;
import net.minecraft.class_1605;
import net.minecraft.class_679;

@Mixin({
		class_1328.class, class_1012.class, class_1270.class, class_1255.class, class_1254.class, class_1232.class,
		class_1036.class, class_1048.class, class_1150.class, class_1292.class, class_679.class
})
@Environment(EnvType.CLIENT)
public abstract class ClientResourceReloadListenerMixins implements IdentifiableResourceReloadListener {
	private Collection<class_1605> fabric_idDeps;
	private class_1605 fabric_id;

	@SuppressWarnings("ConstantConditions")
	@Override
	public Collection<class_1605> getFabricDependencies() {
		if (this.fabric_idDeps == null) {
			Object self = this;

			if (self instanceof class_1292 || self instanceof class_1036) {
				this.fabric_idDeps = Collections.singletonList(ResourceReloadListenerKeys.TEXTURES);
			} else if (self instanceof class_1150 || self instanceof class_1048) {
				this.fabric_idDeps = Collections.singletonList(ResourceReloadListenerKeys.MODELS);
			} else {
				this.fabric_idDeps = Collections.emptyList();
			}
		}

		return this.fabric_idDeps;
	}

	@SuppressWarnings("ConstantConditions")
	@Override
	public class_1605 getFabricId() {
		if (this.fabric_id == null) {
			Object self = this;

			if (self instanceof class_1328) {
				this.fabric_id = ResourceReloadListenerKeys.SOUNDS;
			} else if (self instanceof class_679) {
				this.fabric_id = ResourceReloadListenerKeys.FONTS;
			} else if (self instanceof class_1292) {
				this.fabric_id = ResourceReloadListenerKeys.MODELS;
			} else if (self instanceof class_1270) {
				this.fabric_id = ResourceReloadListenerKeys.LANGUAGES;
			} else if (self instanceof class_1232) {
				this.fabric_id = ResourceReloadListenerKeys.TEXTURES;
			} else {
				MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
				this.fabric_id = new class_1605("minecraft", "private/" + resolver.mapClassName("intermediary", self.getClass().getName()).toLowerCase(Locale.ROOT));
			}
		}

		return this.fabric_id;
	}
}
