/*
 * Decompiled with CFR 0.152.
 */
package net.legacyfabric.fabric.impl.resource.loader;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

class DeferredNioExecutionHandler {
    private static final boolean DEFER_REQUESTED = System.getProperty("fabric.resource-loader.deferFilesystemOperations", "false").equalsIgnoreCase("true");
    private static ExecutorService EXECUTOR_SERVICE;

    DeferredNioExecutionHandler() {
    }

    public static boolean shouldDefer() {
        return DEFER_REQUESTED;
    }

    public static <V> V submit(Callable<V> callable, boolean cond) throws IOException {
        try {
            return cond ? DeferredNioExecutionHandler.submit(callable) : callable.call();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception which should not happen!", e);
        }
    }

    public static <V> V submit(Callable<V> callable) throws IOException {
        if (EXECUTOR_SERVICE == null) {
            EXECUTOR_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Fabric Deferred I/O Thread").build());
        }
        Future<V> future = EXECUTOR_SERVICE.submit(callable);
        return DeferredNioExecutionHandler.getSubmittedFuture(future);
    }

    static <V> V getSubmittedFuture(Future<V> future) throws IOException {
        while (true) {
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException("ExecutionException which should not happen!", t);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

