package quickcarpet.api;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public interface ServerEventListener {
    default Class<?> getSettingsClass() {
        return null;
    }
    default void onServerInit(MinecraftServer server) {}
    default void onServerLoaded(MinecraftServer server) {}
    default void tick(MinecraftServer server) {}
    default void onGameStarted(EnvType type) {
        onGameStarted();
    }
    default void onGameStarted() {}
    default void registerCommands(CommandDispatcher<class_2168> dispatcher) {}

    /**
     * Called when a player connects to the server
     * @param player The player connecting
     * @since 2.0.0
     */
    default void onPlayerConnect(class_3222 player) {}

    /**
     * Called when a player disconnects to the server
     * @param player The player disconnecting
     * @since 2.0.0
     */
    default void onPlayerDisconnect(class_3222 player) {}

    default void onWorldsLoaded(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) onWorldLoaded(world);
    }
    default void onWorldLoaded(class_3218 world) {}

    default void onWorldsSaved(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) onWorldSaved(world);
    }
    default void onWorldSaved(class_3218 world) {}

    default void onWorldsUnloaded(MinecraftServer server) {
        for (class_3218 world : server.method_3738()) onWorldUnloaded(world);
    }
    default void onWorldUnloaded(class_3218 world) {}

    default boolean isIgnoredForRegistrySync(class_2960 registry, class_2960 entry) {
        return false;
    }
}
