package quickcarpet.api.settings;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import quickcarpet.api.module.QuickCarpetModule;

import javax.annotation.Nullable;
import net.minecraft.class_2168;
import net.minecraft.class_2588;
import java.lang.reflect.Field;
import java.util.List;

public interface ParsedRule<T> {
    @Nullable
    QuickCarpetModule getModule();
    SettingsManager getManager();

    Rule getRule();
    Field getField();
    String getShortName();
    String getName();
    class_2588 getDescription();
    @Nullable
    class_2588 getExtraInfo();
    @Nullable
    class_2588 getDeprecated();
    List<RuleCategory> getCategories();
    List<String> getOptions();
    Class<T> getType();
    Validator<T> getValidator();
    ChangeListener<T> getChangeListener();
    boolean isDisabled();

    ArgumentType<?> getArgumentType();
    T getArgument(CommandContext<class_2168> context) throws CommandSyntaxException;

    T get();
    String getAsString();
    boolean getBoolValue();
    void set(String value, boolean sync);
    void set(T value, boolean sync);

    T getDefaultValue();
    String getDefaultAsString();
    boolean isDefault();
    void resetToDefault(boolean sync);

    T getSaved();
    String getSavedAsString();
    void save();
    boolean hasSavedValue();

    class ValueException extends IllegalArgumentException {
        public final class_2588 message;

        public ValueException(class_2588 message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return message.getString();
        }
    }
}
