/*
 * Decompiled with CFR 0.152.
 */
package quickcarpet.api.settings;

import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public interface Validator<T> {
    public Optional<class_2561> validate(T var1);

    default public String getName() {
        return this.getClass().getName();
    }

    public static abstract class Range<T extends Comparable<T>>
    implements Validator<T> {
        public final T min;
        public final T max;
        public final boolean minIncluded;
        public final boolean maxIncluded;

        protected Range(T min, T max) {
            this(min, max, true, true);
        }

        protected Range(T min, T max, boolean minIncluded, boolean maxIncluded) {
            this.min = min;
            this.max = max;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
        }

        @Override
        public String getName() {
            return "Range " + (this.minIncluded ? "[" : "(") + this.min + "," + this.max + (this.maxIncluded ? "]" : ")");
        }

        @Override
        public Optional<class_2561> validate(T value) {
            int minCompare = value.compareTo(this.min);
            int maxCompare = value.compareTo(this.max);
            if (0 < minCompare && maxCompare < 0 || minCompare == 0 && this.minIncluded || maxCompare == 0 && this.maxIncluded) {
                return Optional.empty();
            }
            return Optional.of(new class_2588("carpet.validator.range", new Object[]{new class_2585(this.min.toString()).method_27692(class_124.field_1075), new class_2585(this.max.toString()).method_27692(class_124.field_1075)}));
        }
    }

    public static class OpLevel
    implements Validator<Integer> {
        @Override
        public Optional<class_2561> validate(Integer value) {
            if (value >= 0 && value <= 4) {
                return Optional.empty();
            }
            return Optional.of(new class_2588("carpet.validator.range", new Object[]{new class_2585("0").method_27692(class_124.field_1075), new class_2585("4").method_27692(class_124.field_1075)}));
        }

        @Override
        public String getName() {
            return "OP Level (0-4)";
        }
    }

    public static class Negative<T extends Number>
    implements Validator<T> {
        @Override
        public Optional<class_2561> validate(T value) {
            if (((Number)value).doubleValue() < 0.0) {
                return Optional.empty();
            }
            return Optional.of(new class_2588("carpet.validator.negative"));
        }

        @Override
        public String getName() {
            return "< 0";
        }
    }

    public static class NonNegative<T extends Number>
    implements Validator<T> {
        @Override
        public Optional<class_2561> validate(T value) {
            if (((Number)value).doubleValue() >= 0.0) {
                return Optional.empty();
            }
            return Optional.of(new class_2588("carpet.validator.nonNegative"));
        }

        @Override
        public String getName() {
            return ">= 0";
        }
    }

    public static class Positive<T extends Number>
    implements Validator<T> {
        @Override
        public Optional<class_2561> validate(T value) {
            if (((Number)value).doubleValue() > 0.0) {
                return Optional.empty();
            }
            return Optional.of(new class_2588("carpet.validator.positive"));
        }

        @Override
        public String getName() {
            return "> 0";
        }
    }

    public static class AlwaysTrue<T>
    implements Validator<T> {
        @Override
        public Optional<class_2561> validate(T value) {
            return Optional.empty();
        }
    }
}

